/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.ImportedModule;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.collect.Maps;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCleanupDataService
extends AbstractProjectDataService<ImportedModule, Void> {
    @NotNull
    public Key<ImportedModule> getTargetDataKey() {
        return AndroidProjectKeys.IMPORTED_MODULE;
    }

    public void importData(@NotNull Collection<DataNode<ImportedModule>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (!AndroidStudioInitializer.isAndroidStudio()) {
            return;
        }
        Module[] modules = modelsProvider.getModules();
        if (modules.length != toImport.size()) {
            HashMap modulesByName = Maps.newHashMap();
            for (Module module : modules) {
                modulesByName.put(module.getName(), module);
            }
            for (DataNode dataNode : toImport) {
                String importedModuleName = ((ImportedModule)dataNode.getData()).getName();
                modulesByName.remove(importedModuleName);
            }
            List<Module> modulesToDispose = Collections.emptyList();
            if (!modulesByName.isEmpty()) {
                modulesToDispose = modulesByName.values();
            }
            Projects.setModulesToDisposePostSync(project, modulesToDispose.isEmpty() ? null : modulesToDispose);
        }
    }
}

