/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.cpp.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.customizer.cpp.NativeAndroidGradleFacetModuleCustomizer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidGradleModelDataService
extends AbstractProjectDataService<NativeAndroidGradleModel, Void> {
    private static final Logger LOG = Logger.getInstance(NativeAndroidGradleModelDataService.class);
    private final ImmutableList<ModuleCustomizer<NativeAndroidGradleModel>> myCustomizers = ImmutableList.of((Object)new NativeAndroidGradleFacetModuleCustomizer(), (Object)new ContentRootModuleCustomizer());

    @NotNull
    public Key<NativeAndroidGradleModel> getTargetDataKey() {
        return AndroidProjectKeys.NATIVE_ANDROID_MODEL;
    }

    public void importData(@NotNull Collection<DataNode<NativeAndroidGradleModel>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        try {
            this.doImport(toImport, project, modelsProvider);
        }
        catch (Throwable e) {
            LOG.error(String.format("Failed to set up Native Android Gradle modules in project '%1$s'", project.getName()), e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.getClass().getCanonicalName();
            }
            GradleSyncState.getInstance(project).syncFailed(msg);
        }
    }

    private void doImport(final Collection<DataNode<NativeAndroidGradleModel>> toImport, final Project project, final IdeModifiableModelsProvider modelsProvider) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                Map androidModelsByModuleName = NativeAndroidGradleModelDataService.indexByModuleName(toImport);
                for (Module module : modelsProvider.getModules()) {
                    NativeAndroidGradleModel androidModel = (NativeAndroidGradleModel)androidModelsByModuleName.get(module.getName());
                    NativeAndroidGradleModelDataService.this.customizeModule(module, project, modelsProvider, androidModel);
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    @NotNull
    private static Map<String, NativeAndroidGradleModel> indexByModuleName(@NotNull Collection<DataNode<NativeAndroidGradleModel>> nodes) {
        HashMap index = Maps.newHashMap();
        for (DataNode<NativeAndroidGradleModel> dataNode : nodes) {
            NativeAndroidGradleModel androidModel = (NativeAndroidGradleModel)dataNode.getData();
            index.put(androidModel.getModuleName(), androidModel);
        }
        return index;
    }

    private void customizeModule(@NotNull Module module, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable NativeAndroidGradleModel androidModel) {
        for (ModuleCustomizer customizer : this.myCustomizers) {
            customizer.customizeModule(project, module, modelsProvider, androidModel);
        }
    }
}

