/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.fd.InstantRunTasksProvider;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.collect.Lists;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleModuleTasksProvider
implements InstantRunTasksProvider {
    private final Module[] myModules;

    GradleModuleTasksProvider(@NotNull Module[] modules) {
        this.myModules = modules;
        if (this.myModules.length == 0) {
            throw new IllegalArgumentException("No modules provided");
        }
    }

    @Override
    @NotNull
    public List<String> getCleanAndGenerateSourcesTasks() {
        ArrayList tasks = Lists.newArrayList();
        tasks.addAll(GradleInvoker.findCleanTasksForModules(this.myModules));
        tasks.addAll(GradleInvoker.findTasksToExecute(this.myModules, BuildMode.SOURCE_GEN, GradleInvoker.TestCompileType.NONE));
        return tasks;
    }

    @NotNull
    public List<String> getUnitTestTasks(@NotNull BuildMode buildMode) {
        Module[] affectedModules = GradleModuleTasksProvider.getAffectedModules(this.myModules[0].getProject(), this.myModules);
        return GradleInvoker.findTasksToExecute(affectedModules, buildMode, GradleInvoker.TestCompileType.JAVA_TESTS);
    }

    @NotNull
    private static Module[] getAffectedModules(@NotNull Project project, @NotNull Module[] modules) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = compilerManager.createModulesCompileScope(modules, true, true);
        return scope.getAffectedModules();
    }

    @Override
    @NotNull
    public List<String> getFullBuildTasks() {
        return this.getTasksFor(BuildMode.ASSEMBLE, GradleInvoker.TestCompileType.NONE);
    }

    @NotNull
    public List<String> getTasksFor(@NotNull BuildMode buildMode, @NotNull GradleInvoker.TestCompileType testCompileType) {
        return GradleInvoker.findTasksToExecute(this.myModules, buildMode, testCompileType);
    }
}

