/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.compatibility.ComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.FileLocation;
import com.android.tools.idea.gradle.project.compatibility.VersionRange;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.google.common.base.Splitter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildFileComponentVersionReader
implements ComponentVersionReader {
    @NotNull
    private final String myComponentName;
    @Nullable
    private final BuildFileKey myKey;

    BuildFileComponentVersionReader(@NotNull String keyPath) {
        List segments = Splitter.on((char)'/').splitToList((CharSequence)keyPath);
        this.myComponentName = (String)segments.get(segments.size() - 1);
        this.myKey = BuildFileKey.findByPath(keyPath);
    }

    @Override
    public boolean appliesTo(@NotNull Module module) {
        return AndroidGradleFacet.getInstance(module) != null && GradleBuildFile.get(module) != null;
    }

    @Override
    @Nullable
    public String getComponentVersion(@NotNull Module module) {
        Object value;
        GradleBuildFile buildFile = GradleBuildFile.get(module);
        if (buildFile != null && this.myKey != null && (value = buildFile.getValue(this.myKey)) != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    @Nullable
    public FileLocation getVersionSource(@NotNull Module module) {
        GradleBuildFile buildFile = GradleBuildFile.get(module);
        if (buildFile != null) {
            return new FileLocation(buildFile.getFile());
        }
        return null;
    }

    @Override
    @NotNull
    public List<NotificationHyperlink> getQuickFixes(@NotNull Module module, @Nullable VersionRange expectedVersion, @Nullable FileLocation location) {
        FileLocation source = location;
        if (source == null) {
            source = this.getVersionSource(module);
        }
        if (source != null) {
            OpenBuildFileHyperlink quickFix = new OpenBuildFileHyperlink(module, source);
            return Collections.singletonList(quickFix);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isProjectLevel() {
        return false;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "'" + this.myComponentName + "'";
    }

    private static class OpenBuildFileHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final FileLocation myFileLocation;

        OpenBuildFileHyperlink(@NotNull Module module, @NotNull FileLocation fileLocation) {
            super("openFile", String.format("Open build.gradle file in module '%1$s'", module.getName()));
            this.myFileLocation = fileLocation;
        }

        @Override
        protected void execute(@NotNull Project project) {
            OpenFileDescriptor openFile = new OpenFileDescriptor(project, this.myFileLocation.file, this.myFileLocation.lineNumber, this.myFileLocation.column, false);
            if (openFile.canNavigate()) {
                openFile.navigate(true);
            }
        }
    }
}

