/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.compatibility.ComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.FileLocation;
import com.android.tools.idea.gradle.project.compatibility.VersionRange;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.module.Module;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidGradlePluginVersionReader
implements ComponentVersionReader {
    AndroidGradlePluginVersionReader() {
    }

    @Override
    public boolean appliesTo(@NotNull Module module) {
        return AndroidFacet.getInstance(module) != null;
    }

    @Override
    @Nullable
    public String getComponentVersion(@NotNull Module module) {
        AndroidGradleModel androidModel;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidModel = AndroidGradleModel.get(facet)) != null) {
            return androidModel.getAndroidProject().getModelVersion();
        }
        return null;
    }

    @Override
    @Nullable
    public FileLocation getVersionSource(@NotNull Module module) {
        return null;
    }

    @Override
    @NotNull
    public List<NotificationHyperlink> getQuickFixes(@NotNull Module module, @Nullable VersionRange expectedVersion, @Nullable FileLocation location) {
        String version = "2.2.2";
        if (expectedVersion != null && expectedVersion.contains(version)) {
            FixAndroidGradlePluginVersionHyperlink quickFix = new FixAndroidGradlePluginVersionHyperlink(version, null, false);
            return Collections.singletonList(quickFix);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "Android Gradle plugin";
    }
}

