/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkMerger;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkSync {
    private static final String ERROR_DIALOG_TITLE = "Sync Android SDKs";

    private SdkSync() {
    }

    public static void syncIdeAndProjectAndroidSdks(@NotNull LocalProperties localProperties) {
        SdkSync.syncIdeAndProjectAndroidSdk(localProperties, new FindValidSdkPathTask(), null);
        SdkSync.syncIdeAndProjectAndroidNdk(localProperties);
    }

    public static void syncIdeAndProjectAndroidSdks(@NotNull Project project) throws IOException {
        LocalProperties localProperties = new LocalProperties(project);
        SdkSync.syncIdeAndProjectAndroidSdk(localProperties, new FindValidSdkPathTask(), project);
        SdkSync.syncIdeAndProjectAndroidNdk(localProperties);
    }

    @VisibleForTesting
    static void syncIdeAndProjectAndroidSdk(final @NotNull LocalProperties localProperties, @NotNull FindValidSdkPathTask findSdkPathTask, final @Nullable Project project) {
        if (localProperties.hasAndroidDirProperty()) {
            return;
        }
        final File ideAndroidSdkPath = IdeSdks.getAndroidSdkPath();
        final File projectAndroidSdkPath = localProperties.getAndroidSdkPath();
        if (ideAndroidSdkPath != null) {
            if (projectAndroidSdkPath == null) {
                SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
                return;
            }
            final SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(projectAndroidSdkPath, true);
            if (!validationResult.success) {
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            String error = validationResult.message;
                            if (StringUtil.isEmpty((String)error)) {
                                error = String.format("The path \n'%1$s'\ndoes not refer to a valid Android SDK.", projectAndroidSdkPath.getPath());
                            }
                            String format = "%1$s\n\nAndroid Studio will use this Android SDK instead:\n'%2$s'\nand will modify the project's local.properties file.";
                            Messages.showErrorDialog((String)String.format(format, error, ideAndroidSdkPath.getPath()), (String)SdkSync.ERROR_DIALOG_TITLE);
                        }
                        SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
                    }
                });
                return;
            }
        } else {
            if (projectAndroidSdkPath == null || !IdeSdks.isValidAndroidSdkPath(projectAndroidSdkPath)) {
                File selectedPath = findSdkPathTask.selectValidSdkPath();
                if (selectedPath == null) {
                    throw new ExternalSystemException("Unable to continue until an Android SDK is specified");
                }
                SdkSync.setIdeSdk(localProperties, selectedPath);
                return;
            }
            SdkSync.setIdeSdk(localProperties, projectAndroidSdkPath);
            return;
        }
        if (!FileUtil.filesEqual((File)ideAndroidSdkPath, (File)projectAndroidSdkPath)) {
            final String msg = String.format("The project and Android Studio point to different Android SDKs.\n\nAndroid Studio's default SDK is in:\n%1$s\n\nThe project's SDK (specified in local.properties) is in:\n%2$s\n\nTo keep results consistent between IDE and command line builds, only one path can be used. Do you want to:\n\n[1] Use Android Studio's default SDK (modifies the project's local.properties file.)\n\n[2] Use the project's SDK (modifies Android Studio's default.)\n\nNote that switching SDKs could cause compile errors if the selected SDK doesn't have the necessary Android platforms or build tools.", ideAndroidSdkPath.getPath(), projectAndroidSdkPath.getPath());
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    int result = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Android SDK Manager", (String)msg).yesText("Use Android Studio's SDK")).noText("Use Project's SDK")).project(project)).show();
                    if (result == 0) {
                        SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
                    } else {
                        SdkSync.setIdeSdk(localProperties, projectAndroidSdkPath);
                    }
                    if (AndroidPlugin.isGuiTestingMode() && !AndroidPlugin.getGuiTestSuiteState().isSkipSdkMerge()) {
                        SdkSync.mergeIfNeeded(projectAndroidSdkPath, ideAndroidSdkPath);
                    }
                }
            });
        }
    }

    private static void syncIdeAndProjectAndroidNdk(@NotNull LocalProperties localProperties) {
        File projectAndroidNdkPath = localProperties.getAndroidNdkPath();
        File ideAndroidNdkPath = IdeSdks.getAndroidNdkPath();
        if (projectAndroidNdkPath != null) {
            if (!SdkPaths.validateAndroidNdk((File)projectAndroidNdkPath, (boolean)false).success) {
                if (ideAndroidNdkPath != null) {
                    Logger.getInstance(SdkSync.class).warn(String.format("Replacing invalid NDK path %1$s with %2$s", projectAndroidNdkPath, ideAndroidNdkPath));
                    SdkSync.setProjectNdk(localProperties, ideAndroidNdkPath);
                    return;
                }
                Logger.getInstance(SdkSync.class).warn(String.format("Removing invalid NDK path: %s", projectAndroidNdkPath));
                SdkSync.setProjectNdk(localProperties, null);
            }
            return;
        }
        SdkSync.setProjectNdk(localProperties, ideAndroidNdkPath);
    }

    private static void setProjectNdk(@NotNull LocalProperties localProperties, @Nullable File ndkPath) {
        File currentNdkPath = localProperties.getAndroidNdkPath();
        if (FileUtil.filesEqual((File)currentNdkPath, (File)ndkPath)) {
            return;
        }
        localProperties.setAndroidNdkPath(ndkPath);
        try {
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save '%1$s'", localProperties.getPropertiesFilePath().getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    private static void setIdeSdk(@NotNull LocalProperties localProperties, final @NotNull File projectAndroidSdkPath) {
        SdkSync.setProjectSdk(localProperties, projectAndroidSdkPath);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        IdeSdks.setAndroidSdkPath(projectAndroidSdkPath, null);
                    }
                });
            }
        });
    }

    private static void setProjectSdk(@NotNull LocalProperties localProperties, @NotNull File androidSdkPath) {
        if (FileUtil.filesEqual((File)localProperties.getAndroidSdkPath(), (File)androidSdkPath)) {
            return;
        }
        localProperties.setAndroidSdkPath(androidSdkPath);
        try {
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save '%1$s'", localProperties.getPropertiesFilePath().getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    private static void mergeIfNeeded(final @NotNull File sourceSdk, final @NotNull File destSdk) {
        String msg;
        int result;
        if (SdkMerger.hasMergeableContent(sourceSdk, destSdk) && (result = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Merge SDKs", (String)(msg = String.format("The Android SDK at\n\n%1$s\n\nhas packages not in your project's SDK at\n\n%2$s\n\nWould you like to copy into the project SDK?", sourceSdk.getPath(), destSdk.getPath()))).yesText("Copy")).noText("Do not copy")).show()) == 0) {
            new Task.Backgroundable(null, "Merging Android SDKs", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    SdkMerger.mergeSdks(sourceSdk, destSdk, indicator);
                }
            }.queue();
        }
    }

    @VisibleForTesting
    static class FindValidSdkPathTask {
        FindValidSdkPathTask() {
        }

        @Nullable
        File selectValidSdkPath() {
            final Ref pathRef = new Ref();
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    FindValidSdkPathTask.findValidSdkPath((Ref<File>)pathRef);
                }
            });
            return (File)pathRef.get();
        }

        private static void findValidSdkPath(@NotNull Ref<File> pathRef) {
            Sdk jdk = IdeSdks.getJdk();
            String jdkPath = jdk != null ? jdk.getHomePath() : null;
            SelectSdkDialog dialog = new SelectSdkDialog(jdkPath, null);
            dialog.setModal(true);
            if (!dialog.showAndGet()) {
                String msg = "An Android SDK is needed to continue. Would you like to try again?";
                if (Messages.showYesNoDialog((String)msg, (String)SdkSync.ERROR_DIALOG_TITLE, null) == 0) {
                    FindValidSdkPathTask.findValidSdkPath(pathRef);
                }
                return;
            }
            File path = new File(dialog.getAndroidHome());
            if (!IdeSdks.isValidAndroidSdkPath(path)) {
                String format = "The path\n'%1$s'\ndoes not refer to a valid Android SDK. Would you like to try again?";
                if (Messages.showYesNoDialog((String)String.format(format, path.getPath()), (String)SdkSync.ERROR_DIALOG_TITLE, null) == 0) {
                    FindValidSdkPathTask.findValidSdkPath(pathRef);
                }
                return;
            }
            pathRef.set((Object)path);
        }
    }
}

