/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureUsageTracker {
    private static final Logger LOG = Logger.getInstance(ProjectStructureUsageTracker.class);
    @NotNull
    private final Project myProject;

    ProjectStructureUsageTracker(@NotNull Project project) {
        this.myProject = project;
    }

    void trackProjectStructure() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            try {
                this.trackProjectStructure(moduleManager.getModules());
            }
            catch (Throwable e) {
                LOG.warn("Failed to track project structure", e);
            }
        });
    }

    private void trackProjectStructure(@NotNull Module[] modules) {
        AndroidGradleModel model;
        AndroidGradleModel appModel = null;
        AndroidGradleModel libModel = null;
        int appCount = 0;
        int libCount = 0;
        for (Module module : modules) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            if (androidModel == null) continue;
            AndroidProject androidProject = androidModel.getAndroidProject();
            if (androidProject.isLibrary()) {
                libModel = androidModel;
                ++libCount;
                continue;
            }
            appModel = androidModel;
            ++appCount;
            ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidModel);
        }
        AndroidGradleModel androidGradleModel = model = appModel != null ? appModel : libModel;
        if (model != null) {
            String appId = model.getApplicationId();
            AndroidProject androidProject = model.getAndroidProject();
            GradleVersion gradleVersion = GradleUtil.getGradleVersion(this.myProject);
            ImmutableMap irSettings = ImmutableMap.builder().put((Object)"userEnabledIr", (Object)Boolean.toString(InstantRunSettings.isInstantRunEnabled())).put((Object)"modelSupportsIr", (Object)Boolean.toString(InstantRunGradleUtils.modelSupportsInstantRun(model))).put((Object)"variantSupportsIr", (Object)Boolean.toString(InstantRunGradleUtils.variantSupportsInstantRun(model))).build();
            UsageTracker.getInstance().trackGradleArtifactVersions(appId, androidProject.getModelVersion(), gradleVersion != null ? gradleVersion.toString() : "<Not Found>", (Map<String, String>)irSettings);
            UsageTracker.getInstance().trackModuleCount(appId, modules.length, appCount, libCount);
            for (Module module : modules) {
                NativeAndroidGradleModel nativeAndroidModel;
                AndroidGradleModel androidModel = AndroidGradleModel.get(module);
                if (androidModel != null) {
                    UsageTracker.getInstance().trackAndroidModule(appId, module.getName(), androidModel.isLibrary(), androidModel.getAndroidProject().getSigningConfigs().size(), androidModel.getBuildTypeNames().size(), androidModel.getProductFlavorNames().size(), ProjectStructureUsageTracker.getFlavorDimensions(androidModel).size());
                }
                if ((nativeAndroidModel = NativeAndroidGradleModel.get(module)) != null) {
                    if (nativeAndroidModel.modelVersionIsAtLeast("2.2.0")) {
                        for (String buildSystem : nativeAndroidModel.getNativeAndroidProject().getBuildSystems()) {
                            UsageTracker.getInstance().trackNativeBuildSystem(appId, module.getName(), buildSystem);
                        }
                        continue;
                    }
                    UsageTracker.getInstance().trackNativeBuildSystem(appId, module.getName(), "gradle");
                    continue;
                }
                if (androidModel == null || !ProjectStructureUsageTracker.areNativeLibrariesPresent(androidModel.getAndroidProject())) continue;
                if (GradleUtil.isUsingExperimentalPlugin(module)) {
                    UsageTracker.getInstance().trackNativeBuildSystem(appId, module.getName(), "gradle");
                    continue;
                }
                UsageTracker.getInstance().trackNativeBuildSystem(appId, module.getName(), "ndkCompile");
            }
        }
    }

    private static boolean areNativeLibrariesPresent(@NotNull AndroidProject androidProject) {
        String modelVersion = androidProject.getModelVersion();
        if (modelVersion.startsWith("1.0") || modelVersion.startsWith("1.1") || androidProject.getApiVersion() < 3) {
            return false;
        }
        for (Variant variant : androidProject.getVariants()) {
            if (variant.getMainArtifact().getNativeLibraries().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Collection<String> getFlavorDimensions(@NotNull AndroidGradleModel androidModel) {
        AndroidProject androidProject = androidModel.getAndroidProject();
        try {
            return androidProject.getFlavorDimensions();
        }
        catch (UnsupportedMethodException e) {
            LOG.warn("Invoking 'getFlavorDimensions' on old Gradle model", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static void trackExternalDependenciesInAndroidApp(@NotNull AndroidGradleModel model) {
        Collection variants = model.getAndroidProject().getVariants();
        if (variants.isEmpty()) {
            return;
        }
        Variant chosen = null;
        for (Variant variant : variants) {
            if (!"release".equals(variant.getBuildType())) continue;
            chosen = variant;
            break;
        }
        if (chosen == null) {
            chosen = (Variant)ContainerUtil.getFirstItem((Collection)variants);
        }
        if (chosen != null) {
            ProjectStructureUsageTracker.trackLibraryCount(chosen, model);
        }
    }

    private static void trackLibraryCount(@NotNull Variant variant, @NotNull AndroidGradleModel model) {
        DependencyFiles files = new DependencyFiles();
        AndroidArtifact artifact = variant.getMainArtifact();
        String applicationId = artifact.getApplicationId();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)artifact, model.getModelVersion());
        for (JavaLibrary javaLibrary : dependencies.getJavaLibraries()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(javaLibrary, files);
        }
        for (AndroidLibrary androidLibrary : dependencies.getLibraries()) {
            ProjectStructureUsageTracker.addAarLibraryAndDependencies(androidLibrary, files);
        }
        UsageTracker.getInstance().trackLibraryCount(applicationId, files.jars.size(), files.aars.size());
    }

    private static void addJarLibraryAndDependencies(@NotNull JavaLibrary javaLibrary, @NotNull DependencyFiles files) {
        File jarFile = javaLibrary.getJarFile();
        if (files.jars.contains(jarFile)) {
            return;
        }
        files.jars.add(jarFile);
        for (JavaLibrary dependency : javaLibrary.getDependencies()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(dependency, files);
        }
    }

    private static void addAarLibraryAndDependencies(@NotNull AndroidLibrary androidLibrary, @NotNull DependencyFiles files) {
        String gradlePath = androidLibrary.getProject();
        if (StringUtil.isEmpty((String)gradlePath)) {
            File file = androidLibrary.getJarFile();
            if (files.aars.contains(file)) {
                return;
            }
            files.aars.add(file);
            for (AndroidLibrary library : androidLibrary.getLibraryDependencies()) {
                ProjectStructureUsageTracker.addAarLibraryAndDependencies(library, files);
            }
        }
    }

    @Nullable
    public static String getApplicationId(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidProject androidProject;
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            if (androidModel == null || (androidProject = androidModel.getAndroidProject()).isLibrary()) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    private static class DependencyFiles {
        final Set<File> aars = Sets.newHashSet();
        final Set<File> jars = Sets.newHashSet();

        private DependencyFiles() {
        }
    }
}

