/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.hyperlink.JdkQuickFixes;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

final class ProjectJdkChecks {
    private ProjectJdkChecks() {
    }

    static boolean hasCorrectJdkVersion(@NotNull Module module) {
        AndroidGradleModel androidModel = AndroidGradleModel.get(module);
        if (androidModel != null) {
            return ProjectJdkChecks.hasCorrectJdkVersion(module, androidModel);
        }
        return true;
    }

    static boolean hasCorrectJdkVersion(@NotNull Module module, @NotNull AndroidGradleModel androidModel) {
        Sdk jdk;
        AndroidProject androidProject = androidModel.getAndroidProject();
        String compileTarget = androidProject.getCompileTarget();
        AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
        if (version != null && version.getFeatureLevel() >= 21 && (jdk = IdeSdks.getJdk()) != null && !Jdks.isApplicableJdk(jdk, LanguageLevel.JDK_1_7)) {
            Message msg;
            Project project = module.getProject();
            ArrayList quickFixes = Lists.newArrayList(JdkQuickFixes.getJdkQuickFixes(project));
            String text = "compileSdkVersion " + compileTarget + " requires compiling with JDK 7 or newer";
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            String groupName = "Project Configuration";
            if (buildFile != null) {
                int offset;
                int lineNumber = -1;
                int column = -1;
                Document document = FileDocumentManager.getInstance().getDocument(buildFile);
                if (document != null && (offset = ProjectJdkChecks.findCompileSdkVersionValueOffset(document.getText())) > -1 && (lineNumber = document.getLineNumber(offset)) > -1) {
                    int lineStartOffset = document.getLineStartOffset(lineNumber);
                    column = offset - lineStartOffset;
                }
                quickFixes.add(new OpenFileHyperlink(buildFile.getPath(), "Open build.gradle File", lineNumber, column));
                msg = new Message(project, groupName, Message.Type.ERROR, buildFile, lineNumber, column, text);
            } else {
                msg = new Message(groupName, Message.Type.ERROR, NonNavigatable.INSTANCE, text);
            }
            ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
            messages.add(msg, quickFixes.toArray(new NotificationHyperlink[quickFixes.size()]));
            Projects.setHasWrongJdk(project, true);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static int findCompileSdkVersionValueOffset(@NotNull String buildFileContents) {
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)buildFileContents);
        int end = -1;
        while (lexer.getTokenType() != null) {
            IElementType type = lexer.getTokenType();
            String text = lexer.getTokenText();
            if (type == GroovyTokenTypes.mIDENT) {
                if ("compileSdkVersion".equals(text)) {
                    end = lexer.getTokenEnd();
                } else if (end > -1) {
                    return end;
                }
            } else if (type == TokenType.WHITE_SPACE && end > -1) {
                ++end;
            } else if (end > -1) {
                return end;
            }
            lexer.advance();
        }
        return -1;
    }
}

