/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.PropertyBasedDoNotAskOption;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.android.util.AndroidUiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleVersionRecommendedUpdateDialog
extends DialogWrapper {
    private static final String SHOW_DO_NOT_ASK_TO_UPGRADE_GRADLE_PROPERTY_NAME = "show.do.not.ask.upgrade.gradle";
    @NotNull
    private final Project myProject;
    @NotNull
    private final PropertyBasedDoNotAskOption myDoNotAskOption;
    private JPanel myMainPanel;
    private JEditorPane myMessagePane;
    private JButton[] myButtons;

    public GradleVersionRecommendedUpdateDialog(@NotNull Project project, @NotNull GradleVersion recommendedVersion, @Nullable GradleVersion newPluginVersion) {
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle("Gradle Update Recommended");
        this.myDoNotAskOption = new PropertyBasedDoNotAskOption(project, SHOW_DO_NOT_ASK_TO_UPGRADE_GRADLE_PROPERTY_NAME){

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                return "Don't remind me again for this project";
            }
        };
        this.init();
        AndroidUiUtil.setUpAsHtmlLabel(this.myMessagePane);
        String msg = "<b>It is strongly recommended that you update Gradle to version " + recommendedVersion.toString() + " or later.</b>";
        if (newPluginVersion != null) {
            msg = msg + "<br/>As part of the update, the Android plugin will be updated to version " + newPluginVersion + ".";
        }
        msg = msg + "<br/><br/>For more information, please refer to the <a href='https://developer.android.com/studio/releases/index.html#Revisions'>release notes</a>.";
        this.myMessagePane.setText(msg);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        Action[] actions = this.createActions();
        ArrayList buttons = Lists.newArrayList();
        JPanel panel = new JPanel(new BorderLayout());
        if (actions.length > 0) {
            JPanel buttonsPanel = this.createButtons(actions, buttons);
            panel.add((Component)buttonsPanel, "Center");
            this.myButtons = buttons.toArray(new JButton[buttons.size()]);
        }
        if (this.getStyle() == DialogWrapper.DialogStyle.COMPACT) {
            CustomLineBorder line = new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            return new Action[]{new DoNotAskAction(), this.getCancelAction(), this.getOKAction()};
        }
        return new Action[]{this.getOKAction(), this.getCancelAction(), new DoNotAskAction()};
    }

    @NotNull
    protected Action getOKAction() {
        Action action = super.getOKAction();
        action.putValue("Name", "Update");
        return action;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action = super.getCancelAction();
        action.putValue("Name", "Remind me later");
        return action;
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions, @NotNull List<JButton> buttons) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(4));
        for (Action action : actions) {
            JButton button = this.createJButtonForAction(action);
            Object value = action.getValue("MnemonicKey");
            if (value instanceof Integer) {
                int mnemonic = (Integer)value;
                button.setMnemonic(mnemonic);
            }
            if (action.getValue("FocusedAction") != null) {
                this.myPreferredFocusedComponent = button;
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        return buttonsPanel;
    }

    public void show() {
        if (PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_DO_NOT_ASK_TO_UPGRADE_GRADLE_PROPERTY_NAME, true)) {
            super.show();
        } else {
            this.doCancelAction();
        }
    }

    protected void dispose() {
        super.dispose();
        if (this.myButtons != null) {
            for (JButton button : this.myButtons) {
                button.setAction(null);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMessagePane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(450, 100), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class DoNotAskAction
    extends DialogWrapper.DialogWrapperAction {
        protected DoNotAskAction() {
            super((DialogWrapper)GradleVersionRecommendedUpdateDialog.this, GradleVersionRecommendedUpdateDialog.this.myDoNotAskOption.getDoNotShowMessage());
        }

        protected void doAction(ActionEvent e) {
            GradleVersionRecommendedUpdateDialog.this.myDoNotAskOption.setToBeShown(false, 1);
            GradleVersionRecommendedUpdateDialog.this.doCancelAction();
        }
    }
}

