/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.base.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GradleModelVersionCheck {
    static final GradleVersion MINIMUM_SUPPORTED_VERSION = GradleVersion.parse((String)"1.0.0");

    static boolean isSupportedVersion(@NotNull AndroidProject androidProject) {
        return GradleModelVersionCheck.isSupportedVersion(androidProject, MINIMUM_SUPPORTED_VERSION);
    }

    static boolean isSupportedVersion(@NotNull AndroidProject androidProject, @NotNull GradleVersion minimumSupportedVersion) {
        GradleVersion version = GradleModelVersionCheck.getModelVersion(androidProject);
        if (version != null) {
            return version.compareTo(minimumSupportedVersion) >= 0;
        }
        return false;
    }

    @Nullable
    static GradleVersion getModelVersion(@NotNull AndroidProject androidProject) {
        String modelVersion = androidProject.getModelVersion();
        if (Strings.isNullOrEmpty((String)modelVersion)) {
            return null;
        }
        int snapshotIndex = modelVersion.indexOf("-");
        if (snapshotIndex != -1) {
            modelVersion = modelVersion.substring(0, snapshotIndex);
        }
        return GradleVersion.tryParse((String)modelVersion);
    }

    private GradleModelVersionCheck() {
    }
}

