/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.service.notification.hyperlink.CustomNotificationListener;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.google.common.base.Objects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleNotification {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Android/Gradle Notification Group");
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidGradleNotification getInstance(@NotNull Project project) {
        return (AndroidGradleNotification)ServiceManager.getService((Project)project, AndroidGradleNotification.class);
    }

    public AndroidGradleNotification(@NotNull Project project) {
        this.myProject = project;
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type) {
        this.showBalloon(title, text, type, (NotificationListener)null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, NotificationHyperlink ... hyperlinks) {
        this.showBalloon(title, text, type, NOTIFICATION_GROUP, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, NotificationHyperlink ... hyperlinks) {
        CustomNotificationListener notificationListener = new CustomNotificationListener(this.myProject, hyperlinks);
        String newText = AndroidGradleNotification.addHyperlinksToText(text, hyperlinks);
        this.showBalloon(title, newText, type, group, (NotificationListener)notificationListener);
    }

    @NotNull
    private static String addHyperlinksToText(@NotNull String text, NotificationHyperlink ... hyperlinks) {
        if (hyperlinks.length == 0) {
            return text;
        }
        StringBuilder b = new StringBuilder();
        b.append(text);
        for (NotificationHyperlink hyperlink : hyperlinks) {
            b.append("<br>\n").append(hyperlink.toHtml());
        }
        return b.toString();
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        this.showBalloon(title, text, type, NOTIFICATION_GROUP, listener);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, @Nullable NotificationListener listener) {
        final Notification notification = group.createNotification(title, text, type, listener);
        Runnable notificationTask = new Runnable(){

            @Override
            public void run() {
                if (!AndroidGradleNotification.this.myProject.isDisposed() && AndroidGradleNotification.this.myProject.isOpen()) {
                    boolean similar;
                    Notification old = AndroidGradleNotification.this.myNotification;
                    if (old != null && (similar = Objects.equal((Object)notification.getContent(), (Object)old.getContent()))) {
                        old.expire();
                    }
                    AndroidGradleNotification.this.myNotification = notification;
                    notification.notify(AndroidGradleNotification.this.myProject);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            notificationTask.run();
        } else {
            application.invokeLater(notificationTask);
        }
    }

    @Nullable
    public Notification getNotification() {
        return this.myNotification;
    }
}

