/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class ValueFactory<E> {
    @NotNull
    public List<E> getValues(@NotNull GrStatementOwner closure) {
        ArrayList result = Lists.newArrayList();
        for (PsiElement element : closure.getChildren()) {
            List<E> values = this.getValues(element);
            if (values == null || values.isEmpty()) continue;
            result.addAll(values);
        }
        return result;
    }

    public void setValues(@NotNull GrStatementOwner closure, @NotNull List<E> values, @Nullable KeyFilter filter) {
        for (E value : values) {
            this.setValue(closure, value, filter);
        }
        for (E existingValue : this.findValuesToDelete(closure, values)) {
            this.removeValue(closure, existingValue);
        }
        GradleGroovyFile.reformatClosure(closure);
    }

    protected Iterable<E> findValuesToDelete(@NotNull GrStatementOwner closure, final @NotNull List<E> replacementValues) {
        return Iterables.filter(this.getValues(closure), (Predicate)new Predicate<E>(){

            public boolean apply(E input) {
                return !replacementValues.contains(input);
            }
        });
    }

    @NotNull
    public E parse(@NotNull String s, Project project) {
        throw new UnsupportedOperationException("parse not implemented");
    }

    protected abstract void setValue(@NotNull GrStatementOwner var1, @NotNull E var2, @Nullable KeyFilter var3);

    @Nullable
    protected abstract List<E> getValues(@NotNull PsiElement var1);

    protected void removeValue(@NotNull GrStatementOwner closure, @NotNull E value) {
        throw new UnsupportedOperationException("removeValue not implemented");
    }

    public static interface KeyFilter {
        public boolean shouldWriteKey(BuildFileKey var1, Object var2);
    }
}

