/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleDependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myModuleName;
    @Nullable
    private final String myScope;
    private final boolean myExported;

    @Nullable
    public static JavaModuleDependency copy(IdeaModuleDependency original) {
        IdeaModule module = original.getDependencyModule();
        if (module != null && StringUtil.isNotEmpty((String)module.getName())) {
            String scope = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope = originalScope.getScope();
            }
            return new JavaModuleDependency(module.getName(), scope, original.getExported());
        }
        return null;
    }

    public JavaModuleDependency(@NotNull String moduleName, @Nullable String scope, boolean exported) {
        this.myModuleName = moduleName;
        this.myScope = scope;
        this.myExported = exported;
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    public boolean isExported() {
        return this.myExported;
    }
}

