/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.Serializable;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarLibraryDependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private final String myName;
    @Nullable
    private final File myBinaryPath;
    @Nullable
    private final File mySourcePath;
    @Nullable
    private final File myJavadocPath;
    @Nullable
    private final String myScope;
    @Nullable
    private final GradleModuleVersion myModuleVersion;
    private final boolean myResolved;

    @Nullable
    public static JarLibraryDependency copy(@NotNull IdeaSingleEntryLibraryDependency original) {
        File binaryPath = original.getFile();
        if (binaryPath != null) {
            String name;
            boolean resolved;
            String scope = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope = originalScope.getScope();
            }
            if (resolved = JarLibraryDependency.isResolved(original)) {
                name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
            } else {
                name = JarLibraryDependency.getUnresolvedDependencyName(original);
                if (name == null) {
                    return null;
                }
            }
            return new JarLibraryDependency(name, binaryPath, original.getSource(), original.getJavadoc(), scope, original.getGradleModuleVersion(), resolved);
        }
        return null;
    }

    private static boolean isResolved(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        String libraryName = JarLibraryDependency.getFileName(dependency);
        return libraryName != null && !libraryName.startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
    }

    @Nullable
    private static String getUnresolvedDependencyName(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        String libraryName = JarLibraryDependency.getFileName(dependency);
        if (libraryName == null) {
            return null;
        }
        return libraryName.substring(UNRESOLVED_DEPENDENCY_PREFIX.length()).replace(' ', ':');
    }

    @Nullable
    private static String getFileName(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        File binaryPath = dependency.getFile();
        return binaryPath != null ? binaryPath.getName() : null;
    }

    public JarLibraryDependency(@NotNull String name, @Nullable File binaryPath, @Nullable File sourcePath, @Nullable File javadocPath, @Nullable String scope, @Nullable GradleModuleVersion moduleVersion, boolean resolved) {
        this.myName = name;
        this.myBinaryPath = binaryPath;
        this.mySourcePath = sourcePath;
        this.myJavadocPath = javadocPath;
        this.myScope = scope;
        this.myModuleVersion = moduleVersion;
        this.myResolved = resolved;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public File getBinaryPath() {
        return this.myBinaryPath;
    }

    @Nullable
    public File getSourcePath() {
        return this.mySourcePath;
    }

    @Nullable
    public File getJavadocPath() {
        return this.myJavadocPath;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    @Nullable
    public GradleModuleVersion getModuleVersion() {
        return this.myModuleVersion;
    }

    public boolean isResolved() {
        return this.myResolved;
    }
}

