/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor;

import com.android.tools.idea.gradle.editor.GradleFileEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class GradleFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String EDITOR_TYPE_ID = "android-gradle-editor";
    private static final boolean ENABLED = Boolean.getBoolean("new.android.gradle.editor.active");

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (!ENABLED) {
            return false;
        }
        return file.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && file.getPath().endsWith(".gradle");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return new GradleFileEditor(file, project);
    }

    public void disposeEditor(@NotNull FileEditor editor) {
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
    }

    @NotNull
    public String getEditorTypeId() {
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

