/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GradleDslLiteral
extends GradleDslExpression {
    @Nullable
    private Object myUnsavedValue;
    @Nullable
    private GrClosableBlock myUnsavedConfigBlock;

    public GradleDslLiteral(@NotNull GradleDslElement parent, @NotNull String name) {
        super(parent, null, name, null);
    }

    public GradleDslLiteral(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull String name, @NotNull GrLiteral literal) {
        super(parent, psiElement, name, (GrExpression)literal);
    }

    @Nullable
    public GrLiteral getLiteral() {
        return (GrLiteral)this.myExpression;
    }

    @Override
    @Nullable
    public Object getValue() {
        if (this.myUnsavedValue != null) {
            return this.myUnsavedValue;
        }
        if (this.myExpression == null) {
            return null;
        }
        Object value = ((GrLiteral)this.myExpression).getValue();
        if (value != null) {
            return value;
        }
        if (this.myExpression instanceof GrString) {
            GrStringInjection[] injections;
            String literalText = this.myExpression.getText();
            if (StringUtil.isQuotedString((String)literalText)) {
                literalText = StringUtil.unquoteString((String)literalText);
            }
            ArrayList resolvedVariables = Lists.newArrayList();
            for (GrStringInjection injection : injections = ((GrString)this.myExpression).getInjections()) {
                Object resolvedValue;
                GradleDslExpression resolvedExpression;
                String variableName = null;
                GrClosableBlock closableBlock = injection.getClosableBlock();
                if (closableBlock != null) {
                    String blockText = closableBlock.getText();
                    variableName = blockText.substring(1, blockText.length() - 1);
                } else {
                    GrExpression expression = injection.getExpression();
                    if (expression != null) {
                        variableName = expression.getText();
                    }
                }
                if (StringUtil.isEmpty(variableName) || (resolvedExpression = this.resolveReference(variableName, GradleDslExpression.class)) == null || (resolvedValue = resolvedExpression.getValue()) == null) continue;
                resolvedVariables.add(new GradleResolvedVariable(variableName, resolvedValue, resolvedExpression));
                literalText = literalText.replace(injection.getText(), resolvedValue.toString());
            }
            this.setResolvedVariables(resolvedVariables);
            return literalText;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        Object value = this.getValue();
        if (value != null && clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Override
    public void setValue(@NotNull Object value) {
        this.myUnsavedValue = value;
        this.setModified(true);
    }

    public void setConfigBlock(@NotNull GrClosableBlock block) {
        Preconditions.checkState((this.getPsiElement() == null ? 1 : 0) != 0, (Object)"Can't add configuration block to an existing DSL literal.");
        this.myUnsavedConfigBlock = block;
        this.setModified(true);
    }

    public String toString() {
        Object value = this.getValue();
        return value != null ? value.toString() : super.toString();
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GrNamedArgument addedNameArgument;
        GrLiteral literal;
        if (!(this.myParent instanceof GradleDslExpressionMap)) {
            return super.create();
        }
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        this.setPsiElement(parentPsiElement);
        GrLiteral newLiteral = this.createLiteral();
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory.createNamedArgument(this.myName, (GrExpression)newLiteral);
        Object added = parentPsiElement instanceof GrArgumentList ? ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument) : parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        if (added instanceof GrNamedArgument && (literal = (GrLiteral)PsiTreeUtil.getChildOfType((PsiElement)(addedNameArgument = added), GrLiteral.class)) != null) {
            this.myExpression = literal;
            this.setModified(false);
            return this.getPsiElement();
        }
        return null;
    }

    @Override
    protected void delete() {
        if (this.myExpression == null) {
            return;
        }
        PsiElement parent = this.myExpression.getParent();
        this.myExpression.delete();
        GradleDslLiteral.deleteIfEmpty(parent);
    }

    @Override
    protected void apply() {
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GrLiteral newLiteral = this.createLiteral();
        if (newLiteral == null) {
            return;
        }
        if (this.myExpression != null) {
            PsiElement replace = this.myExpression.replace((PsiElement)newLiteral);
            if (replace instanceof GrLiteral) {
                this.myExpression = (GrLiteral)replace;
            }
        } else {
            PsiElement added = psiElement instanceof GrArgumentList && !(psiElement instanceof GrCommandArgumentList) ? psiElement.addBefore((PsiElement)newLiteral, psiElement.getLastChild()) : psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            if (added instanceof GrLiteral) {
                this.myExpression = (GrLiteral)added;
            }
            if (this.myUnsavedConfigBlock != null) {
                this.addConfigBlock();
            }
        }
    }

    private void addConfigBlock() {
        if (this.myUnsavedConfigBlock == null) {
            return;
        }
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GroovyPsiElementFactory factory = this.getPsiElementFactory();
        if (factory == null) {
            return;
        }
        GrApplicationStatement methodCallStatement = (GrApplicationStatement)factory.createStatementFromText((CharSequence)"foo 1, 2");
        PsiElement comma = methodCallStatement.getArgumentList().getFirstChild().getNextSibling();
        psiElement.addAfter(comma, psiElement.getLastChild());
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        psiElement.addAfter((PsiElement)this.myUnsavedConfigBlock, psiElement.getLastChild());
        this.myUnsavedConfigBlock = null;
    }

    @Override
    protected void reset() {
        this.myUnsavedValue = null;
    }

    @Nullable
    private GrLiteral createLiteral() {
        if (this.myUnsavedValue == null) {
            return null;
        }
        CharSequence unsavedValueText = null;
        if (this.myUnsavedValue instanceof String) {
            unsavedValueText = GrStringUtil.getLiteralTextByValue((String)((String)this.myUnsavedValue));
        } else if (this.myUnsavedValue instanceof Integer || this.myUnsavedValue instanceof Boolean) {
            unsavedValueText = this.myUnsavedValue.toString();
        }
        this.myUnsavedValue = null;
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElementFactory factory = this.getPsiElementFactory();
        if (factory == null) {
            return null;
        }
        GrExpression newExpression = factory.createExpressionFromText(unsavedValueText);
        if (!(newExpression instanceof GrLiteral)) {
            return null;
        }
        return (GrLiteral)newExpression;
    }

    private GroovyPsiElementFactory getPsiElementFactory() {
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        Project project = psiElement.getProject();
        return GroovyPsiElementFactory.getInstance((Project)project);
    }
}

