/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<GradleDslFile> myChildModuleDslFiles = Sets.newHashSet();
    @Nullable
    private GradleDslFile myParentModuleDslFile;
    @Nullable
    private GradleDslFile mySiblingDslFile;

    protected GradleDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        super(null, null, moduleName);
        this.myFile = file;
        this.myProject = project;
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        GroovyFile myPsiFile = null;
        if (psiFile instanceof GroovyFile) {
            myPsiFile = (GroovyFile)psiFile;
        }
        if (myPsiFile == null) {
            return;
        }
        this.setPsiElement((GroovyPsiElement)myPsiFile);
        this.parse(myPsiFile);
    }

    protected void parse(@NotNull GroovyFile myPsiFile) {
        myPsiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitMethodCallExpression(GrMethodCallExpression e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitAssignmentExpression(GrAssignmentExpression e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitApplicationStatement(GrApplicationStatement e) {
                this.process((GroovyPsiElement)e);
            }

            void process(GroovyPsiElement e) {
                GradleDslParser.parse(e, GradleDslFile.this);
            }
        }));
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public File getDirectoryPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
    }

    public void setParentModuleDslFile(@NotNull GradleDslFile parentModuleDslFile) {
        this.myParentModuleDslFile = parentModuleDslFile;
        this.myParentModuleDslFile.myChildModuleDslFiles.add(this);
    }

    @Nullable
    public GradleDslFile getParentModuleDslFile() {
        return this.myParentModuleDslFile;
    }

    @NotNull
    public Collection<GradleDslFile> getChildModuleDslFiles() {
        return this.myChildModuleDslFiles;
    }

    public void setSiblingDslFile(@NotNull GradleDslFile siblingDslFile) {
        this.mySiblingDslFile = siblingDslFile;
    }

    @Nullable
    public GradleDslFile getSiblingDslFile() {
        return this.mySiblingDslFile;
    }
}

