/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.model.repositories.UrlBasedRepositoryModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenCentralRepositoryModel
extends UrlBasedRepositoryModel {
    @NonNls
    public static final String MAVEN_CENTRAL_METHOD_NAME = "mavenCentral";
    @NonNls
    private static final String DEFAULT_REPO_NAME = "MavenRepo";
    @NonNls
    private static final String DEFAULT_REPO_URL = "https://repo1.maven.org/maven2/";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ARTIFACT_URLS = "artifactUrls";
    @Nullable
    private final GradleDslExpressionMap myDslElement;

    public MavenCentralRepositoryModel() {
        this.myDslElement = null;
    }

    public MavenCentralRepositoryModel(@NotNull GradleDslExpressionMap dslElement) {
        this.myDslElement = dslElement;
    }

    @Override
    @NotNull
    public String name() {
        if (this.myDslElement == null) {
            return DEFAULT_REPO_NAME;
        }
        String name = this.myDslElement.getProperty(NAME, String.class);
        return name != null ? name : DEFAULT_REPO_NAME;
    }

    @Override
    @NotNull
    public String url() {
        return DEFAULT_REPO_URL;
    }

    @NotNull
    public List<String> artifactUrls() {
        if (this.myDslElement == null) {
            return ImmutableList.of();
        }
        List<String> artifactUrls = this.myDslElement.getListProperty(ARTIFACT_URLS, String.class);
        if (artifactUrls != null) {
            return artifactUrls;
        }
        String artifactUrl = this.myDslElement.getProperty(ARTIFACT_URLS, String.class);
        if (artifactUrl != null) {
            return ImmutableList.of((Object)artifactUrl);
        }
        return ImmutableList.of();
    }
}

