/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModel
extends GradleDslBlockModel {
    public DependenciesModel(@NotNull DependenciesDslElement dslElement) {
        super(dslElement);
    }

    @NotNull
    public List<DependencyModel> all() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
                if (!(element instanceof GradleDslMethodCall)) continue;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                dependencies.addAll(ModuleDependencyModel.create(configurationName, methodCall));
            }
        }
        return dependencies;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        ArrayList dependencies = Lists.newArrayList();
        this.addArtifacts(configurationName, dependencies);
        return dependencies;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            this.addArtifacts(configurationName, dependencies);
        }
        return dependencies;
    }

    private void addArtifacts(@NotNull String configurationName, @NotNull List<ArtifactDependencyModel> dependencies) {
        GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
        if (list != null) {
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
            }
        }
    }

    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpec.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        ArtifactDependencySpec dependency = ArtifactDependencySpec.create(compactNotation);
        if (dependency == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            throw new IllegalArgumentException(msg);
        }
        this.addArtifact(configurationName, dependency);
        return this;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        return this.addArtifact(configurationName, dependency, Collections.emptyList());
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ArtifactDependencyModel.createAndAddToList(list, configurationName, dependency, excludes);
        return this;
    }

    @NotNull
    public List<ModuleDependencyModel> modules() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(ModuleDependencyModel.create(configurationName, element));
            }
        }
        return dependencies;
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path) {
        return this.addModule(configurationName, path, null);
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path, @Nullable String config) {
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ModuleDependencyModel.createAndAddToList(list, configurationName, path, config);
        return this;
    }

    @NotNull
    private GradleDslElementList getOrCreateGradleDslElementList(@NotNull String configurationName) {
        GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
        if (list == null) {
            list = new GradleDslElementList(this.myDslElement, configurationName);
            this.myDslElement.setNewElement(configurationName, list);
        }
        return list;
    }

    @NotNull
    public List<FileTreeDependencyModel> fileTrees() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileTreeDependencyModel.create(element));
            }
        }
        return dependencies;
    }

    @NotNull
    public DependenciesModel remove(@NotNull DependencyModel dependency) {
        GradleDslElementList gradleDslElementList = this.myDslElement.getProperty(dependency.configurationName(), GradleDslElementList.class);
        if (gradleDslElementList != null) {
            GradleDslElement dependencyElement = dependency.getDslElement();
            GradleDslElement parent = dependencyElement.getParent();
            if (parent instanceof GradleDslMethodCall) {
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
                List<GradleDslElement> arguments = methodCall.getArguments();
                if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                    gradleDslElementList.removeElement(methodCall);
                } else {
                    methodCall.remove(dependencyElement);
                }
            } else {
                gradleDslElementList.removeElement(dependencyElement);
            }
        }
        return this;
    }
}

