/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;

public abstract class ArtifactDependencyModel
extends DependencyModel {
    @NotNull
    public abstract GradleNotNullValue<String> compactNotation();

    @NotNull
    public abstract GradleNotNullValue<String> name();

    @NotNull
    public abstract GradleNullableValue<String> group();

    @NotNull
    public abstract GradleNullableValue<String> version();

    public abstract void setVersion(@NotNull String var1);

    @NotNull
    public abstract GradleNullableValue<String> classifier();

    @NotNull
    public abstract GradleNullableValue<String> extension();

    @NotNull
    static List<ArtifactDependencyModel> create(@NotNull GradleDslElement element) {
        ArrayList results = Lists.newArrayList();
        assert (element instanceof GradleDslExpression || element instanceof GradleDslExpressionMap);
        if (element instanceof GradleDslExpressionMap) {
            MapNotation mapNotation = MapNotation.create((GradleDslExpressionMap)element);
            if (mapNotation != null) {
                results.add(mapNotation);
            }
        } else if (element instanceof GradleDslMethodCall) {
            String name = element.getName();
            if (!"project".equals(name) && !"fileTree".equals(name)) {
                for (GradleDslElement argument : ((GradleDslMethodCall)element).getArguments()) {
                    results.addAll(ArtifactDependencyModel.create(argument));
                }
            }
        } else {
            CompactNotation compactNotation = CompactNotation.create((GradleDslExpression)element);
            if (compactNotation != null) {
                results.add(compactNotation);
            }
        }
        return results;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        GradleDslLiteral literal = new GradleDslLiteral(list, configurationName);
        literal.setValue(dependency.compactNotation());
        if (!excludes.isEmpty()) {
            GrClosableBlock configBlock = ArtifactDependencyModel.buildExcludesBlock(excludes, list.getDslFile().getProject());
            literal.setConfigBlock(configBlock);
        }
        list.addNewElement(literal);
    }

    private static GrClosableBlock buildExcludesBlock(@NotNull List<ArtifactDependencySpec> excludes, @NotNull Project project) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrClosableBlock block = factory.createClosureFromText("{\n}");
        for (ArtifactDependencySpec spec : excludes) {
            String text = String.format("exclude group: '%s', module: '%s'", spec.group, spec.name);
            block.addBefore((PsiElement)factory.createStatementFromText((CharSequence)text), block.getLastChild());
            PsiElement lineTerminator = factory.createLineTerminator(1);
            block.addBefore(lineTerminator, block.getLastChild());
        }
        return block;
    }

    private static class CompactNotation
    extends ArtifactDependencyModel {
        @NotNull
        private GradleDslExpression myDslExpression;
        @NotNull
        private ArtifactDependencySpec mySpec;

        @Nullable
        static CompactNotation create(GradleDslExpression dslExpression) {
            String value = dslExpression.getValue(String.class);
            if (value == null) {
                return null;
            }
            ArtifactDependencySpec spec = ArtifactDependencySpec.create(value);
            if (spec == null) {
                return null;
            }
            return new CompactNotation(dslExpression, spec);
        }

        private CompactNotation(@NotNull GradleDslExpression dslExpression, @NotNull ArtifactDependencySpec spec) {
            this.myDslExpression = dslExpression;
            this.mySpec = spec;
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> compactNotation() {
            return new GradleNotNullValue<String>(this.myDslExpression, this.mySpec.compactNotation());
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> name() {
            return new GradleNotNullValue<String>(this.myDslExpression, this.mySpec.name);
        }

        @Override
        @NotNull
        public GradleNullableValue<String> group() {
            return new GradleNullableValue<String>(this.myDslExpression, this.mySpec.group);
        }

        @Override
        @NotNull
        public GradleNullableValue<String> version() {
            return new GradleNullableValue<String>(this.myDslExpression, this.mySpec.version);
        }

        @Override
        public void setVersion(@NotNull String version) {
            this.mySpec.version = version;
            this.myDslExpression.setValue(this.mySpec.toString());
        }

        @Override
        @NotNull
        public GradleNullableValue<String> classifier() {
            return new GradleNullableValue<String>(this.myDslExpression, this.mySpec.classifier);
        }

        @Override
        @NotNull
        public GradleNullableValue<String> extension() {
            return new GradleNullableValue<String>(this.myDslExpression, this.mySpec.extension);
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            return this.myDslExpression;
        }
    }

    private static class MapNotation
    extends ArtifactDependencyModel {
        @NotNull
        private GradleDslExpressionMap myDslElement;

        @Nullable
        static MapNotation create(GradleDslExpressionMap dslElement) {
            if (dslElement.getPropertyValue("name", String.class).value() == null) {
                return null;
            }
            return new MapNotation(dslElement);
        }

        private MapNotation(@NotNull GradleDslExpressionMap dslElement) {
            this.myDslElement = dslElement;
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> compactNotation() {
            ArtifactDependencySpec spec = new ArtifactDependencySpec(this.name().value(), this.group().value(), this.version().value(), this.classifier().value(), this.extension().value());
            return new GradleNotNullValue<String>(this.myDslElement, spec.compactNotation());
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> name() {
            return GradleNotNullValue.create(this.myDslElement.getPropertyValue("name", String.class));
        }

        @Override
        @NotNull
        public GradleNullableValue<String> group() {
            return this.myDslElement.getPropertyValue("group", String.class);
        }

        @Override
        @NotNull
        public GradleNullableValue<String> version() {
            return this.myDslElement.getPropertyValue("version", String.class);
        }

        @Override
        public void setVersion(@NotNull String version) {
            this.myDslElement.setNewLiteral("version", version);
        }

        @Override
        @NotNull
        public GradleNullableValue<String> classifier() {
            return this.myDslElement.getPropertyValue("classifier", String.class);
        }

        @Override
        @NotNull
        public GradleNullableValue<String> extension() {
            return this.myDslElement.getPropertyValue("ext", String.class);
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            return this.myDslElement;
        }
    }
}

