/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertiesModel
extends GradleFileModel {
    private static final Logger LOG = Logger.getInstance(GradlePropertiesModel.class);

    @Nullable
    public static GradlePropertiesModel parsePropertiesFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        File propertiesFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        try {
            Properties properties = PropertiesUtil.getProperties(propertiesFile);
            GradlePropertiesFile gradlePropertiesFile = new GradlePropertiesFile(properties, file, project, moduleName);
            return new GradlePropertiesModel(gradlePropertiesFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to process " + file.getPath(), (Throwable)e);
            return null;
        }
    }

    private GradlePropertiesModel(@NotNull GradleDslFile gradleDslFile) {
        super(gradleDslFile);
    }

    private static class GradlePropertyElement
    extends GradleDslExpression {
        @Nullable
        private Object myValue;

        private GradlePropertyElement(@Nullable GradleDslElement parent, @NotNull String name) {
            super(parent, null, name, null);
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.myValue;
        }

        @Override
        @Nullable
        public <T> T getValue(@NotNull Class<T> clazz) {
            Object value = this.getValue();
            if (clazz.isInstance(value)) {
                return clazz.cast(value);
            }
            return null;
        }

        @Override
        public void setValue(@NotNull Object value) {
            this.myValue = value;
        }

        @Override
        @NotNull
        protected Collection<GradleDslElement> getChildren() {
            return ImmutableList.of();
        }

        @Override
        protected void apply() {
        }

        @Override
        protected void reset() {
        }
    }

    private static final class GradlePropertiesFile
    extends GradleDslFile {
        private final Properties myProperties;

        private GradlePropertiesFile(@NotNull Properties properties, @NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            super(file, project, moduleName);
            this.myProperties = properties;
        }

        @Override
        public void parse() {
        }

        @Override
        @Nullable
        public GradleDslExpression getPropertyElement(@NotNull String property) {
            String value = this.myProperties.getProperty(property);
            if (value == null) {
                return null;
            }
            GradlePropertyElement propertyElement = new GradlePropertyElement((GradleDslElement)this, property);
            propertyElement.setValue(value);
            return propertyElement;
        }
    }
}

