/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel
extends GradleFileModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NotNull
    private List<String> myToBeAppliedPlugins = new ArrayList<String>();

    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        VirtualFile file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath(project));
        return file != null ? GradleBuildModel.parseBuildFile(file, project, project.getName()) : null;
    }

    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        return GradleBuildModel.parseBuildFile(file, project, "<Unknown>");
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        GradleBuildDslFile buildDslFile = new GradleBuildDslFile(file, project, moduleName);
        GradleBuildModel.populateWithParentModuleSubProjectsProperties(buildDslFile);
        GradleBuildModel.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
        buildDslFile.parse();
        return new GradleBuildModel(buildDslFile);
    }

    private static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildDslFile buildDslFile) {
        GradleSettingsModel gradleSettingsModel = GradleSettingsModel.get(buildDslFile.getProject());
        if (gradleSettingsModel == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (parentModuleModel == null) {
            return;
        }
        GradleDslFile parentModuleDslFile = parentModuleModel.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getProperty("subprojects", SubProjectsDslElement.class);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement("subprojects", subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            buildDslFile.setParsedElement(entry.getKey(), entry.getValue());
        }
    }

    private static void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildDslFile buildDslFile) {
        File propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties");
        VirtualFile propertiesFile = VfsUtil.findFileByIoFile((File)propertiesFilePath, (boolean)true);
        if (propertiesFile == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = GradlePropertiesModel.parsePropertiesFile(propertiesFile, buildDslFile.getProject(), buildDslFile.getName());
        if (propertiesModel == null) {
            return;
        }
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    private GradleBuildModel(@NotNull GradleBuildDslFile buildDslFile) {
        super(buildDslFile);
    }

    @NotNull
    public List<String> appliedPlugins() {
        ApplyDslElement applyDslElement = this.myGradleDslFile.getProperty("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            return ImmutableList.of();
        }
        List<String> listProperty = applyDslElement.getListProperty(PLUGIN, String.class);
        if (listProperty == null) {
            return ImmutableList.of();
        }
        LinkedHashSet plugins = Sets.newLinkedHashSet(listProperty);
        plugins.addAll(this.myToBeAppliedPlugins);
        return ImmutableList.copyOf((Collection)plugins);
    }

    @NotNull
    public GradleBuildModel applyPlugin(String plugin) {
        this.myToBeAppliedPlugins.add(plugin.trim());
        return this;
    }

    @NotNull
    public GradleBuildModel removePlugin(String plugin) {
        plugin = plugin.trim();
        ApplyDslElement applyDslElement = this.myGradleDslFile.getProperty("apply", ApplyDslElement.class);
        if (applyDslElement != null) {
            while (this.appliedPlugins().contains(plugin)) {
                this.myToBeAppliedPlugins.remove(plugin);
                applyDslElement.removeFromExpressionList(PLUGIN, plugin);
            }
        }
        return this;
    }

    @NotNull
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.getProperty("android", AndroidDslElement.class);
        if (androidDslElement == null) {
            androidDslElement = new AndroidDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("android", androidDslElement);
        }
        return new AndroidModel(androidDslElement);
    }

    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.getProperty("buildscript", BuildScriptDslElement.class);
        if (buildScriptDslElement == null) {
            buildScriptDslElement = new BuildScriptDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("buildscript", buildScriptDslElement);
        }
        return new BuildScriptModel(buildScriptDslElement);
    }

    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.getProperty("dependencies", DependenciesDslElement.class);
        if (dependenciesDslElement == null) {
            dependenciesDslElement = new DependenciesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("dependencies", dependenciesDslElement);
        }
        return new DependenciesModel(dependenciesDslElement);
    }

    @NotNull
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getProperty("ext", ExtDslElement.class);
        if (extDslElement == null) {
            extDslElement = new ExtDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("ext", extDslElement);
        }
        return new ExtModel(extDslElement);
    }

    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getProperty("java", JavaDslElement.class);
        if (javaDslElement == null) {
            javaDslElement = new JavaDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("java", javaDslElement);
        }
        return new JavaModel(javaDslElement);
    }

    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.getProperty("repositories", RepositoriesDslElement.class);
        if (repositoriesDslElement == null) {
            repositoriesDslElement = new RepositoriesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("repositories", repositoriesDslElement);
        }
        return new RepositoriesModel(repositoriesDslElement);
    }

    @Override
    public void resetState() {
        this.myToBeAppliedPlugins.clear();
        super.resetState();
    }

    @Override
    public void applyChanges() {
        for (String plugin : this.myToBeAppliedPlugins) {
            GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, "apply");
            applyMap.addNewLiteral(PLUGIN, plugin);
            applyMap.create();
            applyMap.applyChanges();
            this.myGradleDslFile.addParsedElement("apply", applyMap);
        }
        super.applyChanges();
    }

    private static class GradleBuildDslFile
    extends GradleDslFile {
        private GradleBuildDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            super(file, project, moduleName);
        }

        @Override
        public void reparse() {
            super.reparse();
        }

        @Override
        protected void parse(@NotNull GroovyFile psiFile) {
            psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitApplicationStatement(GrApplicationStatement e) {
                    this.process((GroovyPsiElement)e);
                }

                void process(GroovyPsiElement e) {
                    GradleDslParser.parse(e, this);
                }
            }));
        }

        @Override
        public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if ("apply".equals(property) && element instanceof GradleDslExpressionMap) {
                ApplyDslElement applyDslElement = this.getProperty("apply", ApplyDslElement.class);
                if (applyDslElement == null) {
                    applyDslElement = new ApplyDslElement(this);
                    super.addParsedElement("apply", applyDslElement);
                }
                for (Map.Entry<String, GradleDslElement> entry : ((GradleDslExpressionMap)element).getPropertyElements().entrySet()) {
                    applyDslElement.addParsedElement(entry.getKey(), entry.getValue());
                }
                return;
            }
            super.addParsedElement(property, element);
        }

        @Override
        public void setParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (("sourceCompatibility".equals(property) || "targetCompatibility".equals(property)) && (element instanceof GradleDslLiteral || element instanceof GradleDslReference)) {
                JavaDslElement javaDslElement = this.getProperty("java", JavaDslElement.class);
                if (javaDslElement == null) {
                    javaDslElement = new JavaDslElement(this);
                    super.setParsedElement("java", javaDslElement);
                }
                javaDslElement.setParsedElement(property, element);
                return;
            }
            super.setParsedElement(property, element);
        }

        @Override
        protected void reset() {
            super.reset();
        }

        @Override
        protected void apply() {
            super.apply();
        }
    }
}

