/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        return (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies) {
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return Collections.emptyList();
        }
        return GradleDependencyManager.findMissingLibrariesFromGradleBuildFile(buildModel, dependencies);
    }

    public boolean ensureLibraryIsIncluded(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        List<GradleCoordinate> missing = GradleDependencyManager.findMissingLibrariesFromGradleBuildFile(buildModel, dependencies);
        if (missing.isEmpty()) {
            return true;
        }
        if (GradleDependencyManager.userWantToAddDependencies(module, missing)) {
            GradleDependencyManager.addDependenciesInTransaction(buildModel, module, missing, callback);
            return true;
        }
        return false;
    }

    public boolean updateLibrariesToVersion(@NotNull Module module, @NotNull List<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module, dependencies, callback);
        return true;
    }

    @NotNull
    private static List<GradleCoordinate> findMissingLibrariesFromGradleBuildFile(@NotNull GradleBuildModel buildModel, @NotNull Iterable<GradleCoordinate> dependencies) {
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList missingLibraries = Lists.newArrayList();
        for (GradleCoordinate coordinate : dependencies) {
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, null);
            if (resolvedCoordinate == null) {
                if (coordinate.getArtifactId() == null || coordinate.getGroupId() == null) {
                    continue;
                }
            } else {
                coordinate = resolvedCoordinate;
            }
            boolean dependencyFound = false;
            for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts("compile")) {
                if (!Objects.equal((Object)coordinate.getGroupId(), (Object)dependency.group().value()) || !Objects.equal((Object)coordinate.getArtifactId(), (Object)dependency.name().value())) continue;
                dependencyFound = true;
                break;
            }
            if (dependencyFound) continue;
            missingLibraries.add(coordinate);
        }
        return missingLibraries;
    }

    private static boolean userWantToAddDependencies(@NotNull Module module, @NotNull Collection<GradleCoordinate> missing) {
        String libraryNames = StringUtil.join(missing, (Function)new Function<GradleCoordinate, String>(){

            @Nullable
            public String fun(GradleCoordinate coordinate) {
                return coordinate.getArtifactId();
            }
        }, (String)", ");
        String message = String.format("This operation requires the %1$s %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private static void addDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                GradleDependencyManager.addDependencies(buildModel, module, coordinates);
                GradleProjectImporter.getInstance().requestProjectSync(project, false, GradleDependencyManager.createSyncListener(callback));
            }
        }.execute();
    }

    private static void addDependencies(final @NotNull GradleBuildModel buildModel, @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates) {
        ModuleRootModificationUtil.updateModel((Module)module, (Consumer)new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                DependenciesModel dependenciesModel = buildModel.dependencies();
                for (GradleCoordinate coordinate : coordinates) {
                    dependenciesModel.addArtifact("compile", coordinate.toString());
                }
                buildModel.applyChanges();
            }
        });
    }

    private static void updateDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                GradleDependencyManager.updateDependencies(buildModel, module, coordinates);
                GradleProjectImporter.getInstance().requestProjectSync(project, false, GradleDependencyManager.createSyncListener(callback));
            }
        }.execute();
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList artifacts = Lists.newArrayList(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().value()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().value()) || gc.getRevision().equals(m.version().value())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    @Nullable
    private static GradleSyncListener createSyncListener(final @Nullable Runnable callback) {
        if (callback == null) {
            return null;
        }
        return new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                callback.run();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                callback.run();
            }
        };
    }
}

