/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.AbstractCompileOutputModuleCustomizer;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class CompilerOutputModuleCustomizer
extends AbstractCompileOutputModuleCustomizer<JavaProject> {
    @NonNls
    private static final String CLASSES_FOLDER_NAME = "classes";

    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable JavaProject javaProject) {
        if (javaProject == null) {
            return;
        }
        File mainClassesFolder = null;
        File testClassesFolder = null;
        ExtIdeaCompilerOutput compilerOutput = javaProject.getCompilerOutput();
        if (compilerOutput == null) {
            File buildFolderPath = javaProject.getBuildFolderPath();
            if (buildFolderPath != null) {
                mainClassesFolder = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, "main"}));
                testClassesFolder = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, "test"}));
            }
        } else {
            mainClassesFolder = compilerOutput.getMainClassesDir();
            testClassesFolder = compilerOutput.getTestClassesDir();
        }
        if (mainClassesFolder != null) {
            ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
            this.setOutputPaths(moduleModel, mainClassesFolder, testClassesFolder);
        }
    }
}

