/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.dependency;

import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.util.Facets;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependency
extends Dependency {
    @NotNull
    private final String myGradlePath;
    @Nullable
    private LibraryDependency myBackupDependency;

    @VisibleForTesting
    public ModuleDependency(@NotNull String gradlePath, @NotNull DependencyScope scope) {
        super(scope);
        this.myGradlePath = gradlePath;
    }

    @Nullable
    public Module getModule(@NotNull IdeModifiableModelsProvider modelsProvider) {
        for (Module module : modelsProvider.getModules()) {
            AndroidGradleFacet gradleFacet = Facets.findFacet(module, modelsProvider, AndroidGradleFacet.TYPE_ID);
            if (gradleFacet == null || !this.hasEqualPath(gradleFacet)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public Module getModule(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
            if (gradleFacet == null || !this.hasEqualPath(gradleFacet)) continue;
            return module;
        }
        return null;
    }

    private boolean hasEqualPath(@NotNull AndroidGradleFacet facet) {
        String gradlePath = ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
        return StringUtil.isNotEmpty((String)gradlePath) && gradlePath.equals(this.getGradlePath());
    }

    @NotNull
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @Nullable
    public LibraryDependency getBackupDependency() {
        return this.myBackupDependency;
    }

    @VisibleForTesting
    public void setBackupDependency(@Nullable LibraryDependency backupDependency) {
        this.myBackupDependency = backupDependency;
        this.updateBackupDependencyScope();
    }

    @Override
    void setScope(@NotNull DependencyScope scope) throws IllegalArgumentException {
        super.setScope(scope);
        this.updateBackupDependencyScope();
    }

    private void updateBackupDependencyScope() {
        if (this.myBackupDependency != null) {
            this.myBackupDependency.setScope(this.getScope());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "gradlePath=" + this.myGradlePath + ", scope=" + this.getScope() + ", backUpDependency=" + this.myBackupDependency + "]";
    }
}

