/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<AndroidGradleModel>
implements BuildVariantModuleCustomizer<AndroidGradleModel> {
    @Override
    protected void setUpDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidGradleModel androidModel) {
        AndroidProject androidProject = androidModel.getAndroidProject();
        DependencySet dependencies = Dependency.extractFrom(androidModel);
        for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
            DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, libraryDependency, androidProject);
        }
        for (ModuleDependency moduleDependency : dependencies.onModules()) {
            this.updateModuleDependency(module, modelsProvider, moduleDependency, androidProject);
        }
        DependenciesModuleCustomizer.addExtraSdkLibrariesAsDependencies(module, modelsProvider, androidProject);
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(module.getProject());
        Collection<SyncIssue> collection = androidModel.getSyncIssues();
        if (collection != null) {
            messages.reportSyncIssues(collection, module);
        } else {
            Collection unresolvedDependencies = androidProject.getUnresolvedDependencies();
            messages.reportUnresolvedDependencies(unresolvedDependencies, module);
        }
    }

    private void updateModuleDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleDependency dependency, @NotNull AndroidProject androidProject) {
        Module moduleDependency = dependency.getModule(modelsProvider);
        LibraryDependency compiledArtifact = dependency.getBackupDependency();
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addModuleOrderEntry(moduleDependency);
            orderEntry.setExported(true);
            orderEntry.setScope(dependency.getScope());
            if (compiledArtifact != null) {
                Projects.setModuleCompiledArtifact(moduleDependency, compiledArtifact);
            }
            return;
        }
        String backupName = compiledArtifact != null ? compiledArtifact.getName() : null;
        DependencySetupErrors setupErrors = this.getSetupErrors(module.getProject());
        setupErrors.addMissingModule(dependency.getGradlePath(), module.getName(), backupName);
        if (compiledArtifact != null) {
            DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, compiledArtifact, androidProject);
        }
    }

    public static void updateLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependency dependency, @NotNull AndroidProject androidProject) {
        Collection<String> binaryPaths = dependency.getPaths(LibraryDependency.PathType.BINARY);
        Collection<String> sourcePaths = dependency.getPaths(LibraryDependency.PathType.SOURCE);
        Collection<String> docPaths = dependency.getPaths(LibraryDependency.PathType.DOC);
        DependenciesModuleCustomizer.setUpLibraryDependency(module, modelsProvider, dependency.getName(), dependency.getScope(), binaryPaths, sourcePaths, docPaths);
        File buildFolder = androidProject.getBuildFolder();
        ContentEntry[] contentEntries = modelsProvider.getModifiableRootModel(module).getContentEntries();
        for (String binaryPath : binaryPaths) {
            ContentEntry parentContentEntry;
            File parent = new File(binaryPath).getParentFile();
            if (parent == null || !"jars".equals(parent.getName()) || !FileUtil.isAncestor((File)buildFolder, (File)parent, (boolean)true) || (parentContentEntry = FilePaths.findParentContentEntry(parent, contentEntries)) == null) continue;
            parentContentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(parent));
        }
    }

    private static void addExtraSdkLibrariesAsDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidProject androidProject) {
        SdkAdditionalData data;
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        Sdk sdk = moduleModel.getSdk();
        assert (sdk != null);
        String suffix = null;
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData) {
            VirtualFile[] androidSdkData = (VirtualFile[])data;
            suffix = androidSdkData.getBuildTargetHashString();
        }
        if (suffix == null) {
            suffix = androidProject.getCompileTarget();
        }
        HashSet currentIdeSdkFilePaths = Sets.newHashSetWithExpectedSize((int)5);
        for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
            currentIdeSdkFilePaths.add(sdkFilePath.getPath());
        }
        Collection bootClasspath = androidProject.getBootClasspath();
        for (String library : bootClasspath) {
            if (!StringUtil.isNotEmpty((String)library) || currentIdeSdkFilePaths.contains(library)) continue;
            File binaryPath = new File(library);
            String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)library);
            name = name + "-" + suffix;
            DependenciesModuleCustomizer.setUpLibraryDependency(module, modelsProvider, name, DependencyScope.COMPILE, Collections.singletonList(library));
        }
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return GradleUtil.GRADLE_SYSTEM_ID;
    }

    @Override
    @NotNull
    public Class<AndroidGradleModel> getSupportedModelType() {
        return AndroidGradleModel.class;
    }
}

