/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.customizer.AbstractContentRootModuleCustomizer;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.util.Facets;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentRootModuleCustomizer
extends AbstractContentRootModuleCustomizer<AndroidGradleModel>
implements BuildVariantModuleCustomizer<AndroidGradleModel> {
    @Override
    protected boolean shouldRemoveContentEntries(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        NativeAndroidGradleFacet nativeAndroidGradleFacet = Facets.findFacet(module, modelsProvider, NativeAndroidGradleFacet.TYPE_ID);
        return nativeAndroidGradleFacet == null || nativeAndroidGradleFacet.getNativeAndroidGradleModel() == null;
    }

    @Override
    @NotNull
    protected Collection<ContentEntry> findOrCreateContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull AndroidGradleModel androidModel) {
        ArrayList contentEntries = Lists.newArrayList((Object[])new ContentEntry[]{moduleModel.addContentEntry(androidModel.getRootDir())});
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        if (!FileUtil.isAncestor((File)androidModel.getRootDirPath(), (File)buildFolderPath, (boolean)false)) {
            contentEntries.add(moduleModel.addContentEntry(FilePaths.pathToIdeaUrl(buildFolderPath)));
        }
        return contentEntries;
    }

    @Override
    protected void setUpContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull AndroidGradleModel androidModel, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        Variant selectedVariant = androidModel.getSelectedVariant();
        boolean shouldAddNativeSources = NativeAndroidGradleModel.get(moduleModel.getModule()) == null;
        AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        this.addSourceFolders(androidModel, contentEntries, (BaseArtifact)mainArtifact, false, shouldAddNativeSources, orphans);
        for (BaseArtifact artifact : androidModel.getTestArtifactsInSelectedVariant()) {
            this.addSourceFolders(androidModel, contentEntries, artifact, true, shouldAddNativeSources, orphans);
        }
        for (String flavorName : selectedVariant.getProductFlavors()) {
            ProductFlavorContainer flavor = androidModel.findProductFlavor(flavorName);
            if (flavor == null) continue;
            this.addSourceFolder(androidModel, contentEntries, flavor, shouldAddNativeSources, orphans);
        }
        String buildTypeName = selectedVariant.getBuildType();
        BuildTypeContainer buildTypeContainer = androidModel.findBuildType(buildTypeName);
        if (buildTypeContainer != null) {
            this.addSourceFolder(androidModel, contentEntries, buildTypeContainer.getSourceProvider(), false, shouldAddNativeSources, orphans);
            Collection<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(buildTypeContainer.getExtraSourceProviders());
            for (SourceProvider testSourceProvider : testSourceProviders) {
                this.addSourceFolder(androidModel, contentEntries, testSourceProvider, true, shouldAddNativeSources, orphans);
            }
        }
        ProductFlavorContainer defaultConfig = androidModel.getAndroidProject().getDefaultConfig();
        this.addSourceFolder(androidModel, contentEntries, defaultConfig, shouldAddNativeSources, orphans);
        this.addExcludedOutputFolders(contentEntries, androidModel);
    }

    private void addSourceFolders(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull BaseArtifact artifact, boolean isTest, boolean shouldAddNativeSources, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        SourceProvider multiFlavorSourceProvider;
        this.addGeneratedSourceFolders(androidModel, contentEntries, artifact, isTest, orphans);
        SourceProvider variantSourceProvider = artifact.getVariantSourceProvider();
        if (variantSourceProvider != null) {
            this.addSourceFolder(androidModel, contentEntries, variantSourceProvider, isTest, shouldAddNativeSources, orphans);
        }
        if ((multiFlavorSourceProvider = artifact.getMultiFlavorSourceProvider()) != null) {
            this.addSourceFolder(androidModel, contentEntries, multiFlavorSourceProvider, isTest, shouldAddNativeSources, orphans);
        }
    }

    private void addGeneratedSourceFolders(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull BaseArtifact artifact, boolean isTest, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        Collection<File> generatedSourceFolders;
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        GradleVersion modelVersion = androidModel.getModelVersion();
        if ((artifact instanceof AndroidArtifact || modelVersion != null && modelVersion.compareIgnoringQualifiers("1.2") >= 0) && (generatedSourceFolders = GradleUtil.getGeneratedSourceFolders(artifact)) != null) {
            this.addSourceFolders(androidModel, contentEntries, generatedSourceFolders, sourceType, true, orphans);
        }
        if (artifact instanceof AndroidArtifact) {
            sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
            this.addSourceFolders(androidModel, contentEntries, ((AndroidArtifact)artifact).getGeneratedResourceFolders(), sourceType, true, orphans);
        }
    }

    private void addSourceFolder(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull ProductFlavorContainer flavor, boolean shouldAddNativeSources, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        this.addSourceFolder(androidModel, contentEntries, flavor.getSourceProvider(), false, shouldAddNativeSources, orphans);
        Collection<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(flavor.getExtraSourceProviders());
        for (SourceProvider sourceProvider : testSourceProviders) {
            this.addSourceFolder(androidModel, contentEntries, sourceProvider, true, shouldAddNativeSources, orphans);
        }
    }

    private void addSourceFolder(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull SourceProvider sourceProvider, boolean isTest, boolean shouldAddNativeSources, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getResDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getResourcesDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getAssetsDirectories(), sourceType, false, orphans);
        sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getAidlDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getJavaDirectories(), sourceType, false, orphans);
        if (shouldAddNativeSources) {
            this.addSourceFolders(androidModel, contentEntries, sourceProvider.getCDirectories(), sourceType, false, orphans);
            this.addSourceFolders(androidModel, contentEntries, sourceProvider.getCppDirectories(), sourceType, false, orphans);
        }
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getRenderscriptDirectories(), sourceType, false, orphans);
        if (androidModel.getFeatures().isShadersSupported()) {
            this.addSourceFolders(androidModel, contentEntries, sourceProvider.getShadersDirectories(), sourceType, false, orphans);
        }
    }

    @NotNull
    private static JpsModuleSourceRootType getResourceSourceType(boolean isTest) {
        return isTest ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
    }

    @NotNull
    private static JpsModuleSourceRootType getSourceType(boolean isTest) {
        return isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
    }

    private void addSourceFolders(@NotNull AndroidGradleModel androidModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull Collection<File> folderPaths, @NotNull JpsModuleSourceRootType type, boolean generated, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        for (File folderPath : folderPaths) {
            if (generated && !ContentRootModuleCustomizer.isGeneratedAtCorrectLocation(folderPath, androidModel.getAndroidProject())) {
                androidModel.registerExtraGeneratedSourceFolder(folderPath);
            }
            this.addSourceFolder(contentEntries, folderPath, type, generated, orphans);
        }
    }

    private static boolean isGeneratedAtCorrectLocation(@NotNull File folderPath, @NotNull AndroidProject project) {
        File generatedFolderPath = new File(project.getBuildFolder(), "generated");
        return FileUtil.isAncestor((File)generatedFolderPath, (File)folderPath, (boolean)false);
    }

    private void addExcludedOutputFolders(@NotNull Collection<ContentEntry> contentEntries, @NotNull AndroidGradleModel androidModel) {
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        ContentEntry parentContentEntry = FilePaths.findParentContentEntry(buildFolderPath, contentEntries);
        if (parentContentEntry != null) {
            List<File> excludedFolderPaths = androidModel.getExcludedFolderPaths();
            for (File folderPath : excludedFolderPaths) {
                this.addExcludedFolder(parentContentEntry, folderPath);
            }
        }
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return GradleUtil.GRADLE_SYSTEM_ID;
    }

    @Override
    @NotNull
    public Class<AndroidGradleModel> getSupportedModelType() {
        return AndroidGradleModel.class;
    }
}

