/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.Facets;
import com.google.common.base.Strings;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacetModuleCustomizer
implements ModuleCustomizer<AndroidGradleModel> {
    private static final String SEPARATOR = "/";

    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable AndroidGradleModel androidModel) {
        if (androidModel == null) {
            Facets.removeAllFacetsOfType(AndroidFacet.ID, modelsProvider.getModifiableFacetModel(module));
        } else {
            AndroidFacet facet = Facets.findFacet(module, modelsProvider, AndroidFacet.ID);
            if (facet != null) {
                AndroidFacetModuleCustomizer.configureFacet(facet, androidModel);
            } else {
                ModifiableFacetModel model = modelsProvider.getModifiableFacetModel(module);
                AndroidFacetType facetType = AndroidFacet.getFacetType();
                facet = facetType.createFacet(module, "Android", facetType.createDefaultConfiguration(), (Facet)null);
                model.addFacet((Facet)facet);
                AndroidFacetModuleCustomizer.configureFacet(facet, androidModel);
            }
        }
    }

    private static void configureFacet(@NotNull AndroidFacet facet, @NotNull AndroidGradleModel androidModel) {
        JpsAndroidModuleProperties facetState = facet.getProperties();
        facetState.ALLOW_USER_CONFIGURATION = false;
        AndroidProject androidProject = androidModel.getAndroidProject();
        facetState.LIBRARY_PROJECT = androidProject.isLibrary();
        SourceProvider sourceProvider = androidModel.getDefaultSourceProvider();
        AndroidFacetModuleCustomizer.syncSelectedVariantAndTestArtifact(facetState, androidModel);
        File moduleDirPath = androidModel.getRootDirPath();
        File manifestFile = sourceProvider.getManifestFile();
        facetState.MANIFEST_FILE_RELATIVE_PATH = AndroidFacetModuleCustomizer.relativePath(moduleDirPath, manifestFile);
        Collection resDirs = sourceProvider.getResDirectories();
        facetState.RES_FOLDER_RELATIVE_PATH = AndroidFacetModuleCustomizer.relativePath(moduleDirPath, resDirs);
        Collection assetsDirs = sourceProvider.getAssetsDirectories();
        facetState.ASSETS_FOLDER_RELATIVE_PATH = AndroidFacetModuleCustomizer.relativePath(moduleDirPath, assetsDirs);
        facet.setAndroidModel(androidModel);
        androidModel.syncSelectedVariantAndTestArtifact(facet);
    }

    private static void syncSelectedVariantAndTestArtifact(@NotNull JpsAndroidModuleProperties facetState, @NotNull AndroidGradleModel androidModel) {
        String testArtifactStoredInFacet;
        String variantStoredInFacet = facetState.SELECTED_BUILD_VARIANT;
        if (!Strings.isNullOrEmpty((String)variantStoredInFacet) && androidModel.getVariantNames().contains(variantStoredInFacet)) {
            androidModel.setSelectedVariantName(variantStoredInFacet);
        }
        if (!Strings.isNullOrEmpty((String)(testArtifactStoredInFacet = facetState.SELECTED_TEST_ARTIFACT))) {
            androidModel.setSelectedTestArtifactName(testArtifactStoredInFacet);
        }
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @NotNull Collection<File> dirs) {
        return AndroidFacetModuleCustomizer.relativePath(basePath, (File)ContainerUtil.getFirstItem(dirs));
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @Nullable File file) {
        String relativePath = null;
        if (file != null) {
            relativePath = FileUtilRt.getRelativePath((File)basePath, (File)file);
        }
        if (relativePath != null && !relativePath.startsWith(SEPARATOR)) {
            return SEPARATOR + FileUtilRt.toSystemIndependentName((String)relativePath);
        }
        return "";
    }
}

