/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidGradleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(NativeAndroidGradleModel.class);
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private NativeAndroidProject myNativeAndroidProject;
    @Nullable
    private transient GradleVersion myModelVersion;
    @Nullable
    private transient CountDownLatch myProxyNativeAndroidProjectLatch;
    @Nullable
    private NativeAndroidProject myProxyNativeAndroidProject;
    @NotNull
    private Map<String, NativeVariant> myVariantsByName = Maps.newHashMap();
    @NotNull
    private Map<String, NativeToolchain> myToolchainsByName = Maps.newHashMap();
    @NotNull
    private Map<String, NativeSettings> mySettingsByName = Maps.newHashMap();
    @NotNull
    private String mySelectedVariantName;

    @Nullable
    public static NativeAndroidGradleModel get(@NotNull Module module) {
        NativeAndroidGradleFacet facet = NativeAndroidGradleFacet.getInstance(module);
        return facet != null ? NativeAndroidGradleModel.get(facet) : null;
    }

    @Nullable
    public static NativeAndroidGradleModel get(@NotNull NativeAndroidGradleFacet androidFacet) {
        NativeAndroidGradleModel androidModel = androidFacet.getNativeAndroidGradleModel();
        if (androidModel == null) {
            return null;
        }
        return androidModel;
    }

    public NativeAndroidGradleModel(@NotNull ProjectSystemId projectSystemId, @NotNull String moduleName, @NotNull File rootDirPath, @NotNull NativeAndroidProject nativeAndroidProject) {
        this.myProjectSystemId = projectSystemId;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myNativeAndroidProject = nativeAndroidProject;
        this.parseAndSetModelVersion();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myProxyNativeAndroidProjectLatch = new CountDownLatch(1);
            this.myProxyNativeAndroidProject = ProxyUtil.reproxy(NativeAndroidProject.class, this.myNativeAndroidProject);
            this.myProxyNativeAndroidProjectLatch.countDown();
        });
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
        this.initializeSelectedVariant();
    }

    private void populateVariantsByName() {
        for (NativeArtifact artifact : this.myNativeAndroidProject.getArtifacts()) {
            String variantName = this.modelVersionIsAtLeast("2.0.0") ? artifact.getGroupName() : artifact.getName();
            NativeVariant variant = this.myVariantsByName.get(variantName);
            if (variant == null) {
                variant = new NativeVariant(variantName);
                this.myVariantsByName.put(variant.getName(), variant);
            }
            variant.addArtifact(artifact);
        }
        if (this.myVariantsByName.isEmpty()) {
            this.myVariantsByName.put("-----", new NativeVariant("-----"));
        }
    }

    private void populateToolchainsByName() {
        for (NativeToolchain toolchain : this.myNativeAndroidProject.getToolChains()) {
            this.myToolchainsByName.put(toolchain.getName(), toolchain);
        }
    }

    private void populateSettingsByName() {
        for (NativeSettings settings : this.myNativeAndroidProject.getSettings()) {
            this.mySettingsByName.put(settings.getName(), settings);
        }
    }

    private void initializeSelectedVariant() {
        Set<String> variantNames = this.myVariantsByName.keySet();
        assert (!variantNames.isEmpty());
        if (variantNames.size() == 1) {
            this.mySelectedVariantName = (String)Iterables.getOnlyElement(variantNames);
            return;
        }
        for (String variantName : variantNames) {
            if (!variantName.equals("debug")) continue;
            this.mySelectedVariantName = variantName;
            return;
        }
        ArrayList sortedVariantNames = Lists.newArrayList(variantNames);
        Collections.sort(sortedVariantNames);
        assert (!sortedVariantNames.isEmpty());
        this.mySelectedVariantName = (String)sortedVariantNames.get(0);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myNativeAndroidProject.getModelVersion());
    }

    public boolean modelVersionIsAtLeast(@NotNull String revision) {
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @NotNull
    public NativeAndroidProject getNativeAndroidProject() {
        return this.myNativeAndroidProject;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        return this.myVariantsByName.keySet();
    }

    @NotNull
    public Collection<NativeVariant> getVariants() {
        return this.myVariantsByName.values();
    }

    @NotNull
    public NativeVariant getSelectedVariant() {
        NativeVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        return selected;
    }

    public void setSelectedVariantName(@NotNull String name) {
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(name)) {
            this.mySelectedVariantName = name;
        } else {
            this.initializeSelectedVariant();
        }
    }

    @Nullable
    public NativeToolchain findToolchain(@NotNull String toolchainName) {
        return this.myToolchainsByName.get(toolchainName);
    }

    @Nullable
    public NativeSettings findSettings(@NotNull String settingsName) {
        return this.mySettingsByName.get(settingsName);
    }

    @NotNull
    public NativeAndroidProject waitForAndGetProxyAndroidProject() {
        this.waitForProxyAndroidProject();
        assert (this.myProxyNativeAndroidProject != null);
        return this.myProxyNativeAndroidProject;
    }

    public void waitForProxyAndroidProject() {
        if (this.myProxyNativeAndroidProjectLatch != null) {
            try {
                this.myProxyNativeAndroidProjectLatch.await();
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.waitForProxyAndroidProject();
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyNativeAndroidProject);
        out.writeObject(this.mySelectedVariantName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myNativeAndroidProject = (NativeAndroidProject)in.readObject();
        this.mySelectedVariantName = (String)in.readObject();
        this.parseAndSetModelVersion();
        this.myProxyNativeAndroidProject = this.myNativeAndroidProject;
        this.myVariantsByName = Maps.newHashMap();
        this.myToolchainsByName = Maps.newHashMap();
        this.mySettingsByName = Maps.newHashMap();
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
    }

    public class NativeVariant {
        @NotNull
        private final String myVariantName;
        @NotNull
        private final Map<String, NativeArtifact> myArtifactsByName = Maps.newHashMap();

        private NativeVariant(String variantName) {
            this.myVariantName = variantName;
        }

        private void addArtifact(@NotNull NativeArtifact artifact) {
            this.myArtifactsByName.put(artifact.getName(), artifact);
        }

        @NotNull
        public String getName() {
            return this.myVariantName;
        }

        @NotNull
        public Collection<NativeArtifact> getArtifacts() {
            return this.myArtifactsByName.values();
        }

        @NotNull
        public Collection<File> getSourceFolders() {
            LinkedHashSet sourceFolders = Sets.newLinkedHashSet();
            for (NativeArtifact artifact : this.getArtifacts()) {
                if (NativeAndroidGradleModel.this.modelVersionIsAtLeast("2.0.0")) {
                    for (File headerRoot : artifact.getExportedHeaders()) {
                        sourceFolders.add(headerRoot);
                    }
                }
                for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                    sourceFolders.add(sourceFolder.getFolderPath());
                }
                for (NativeFile sourceFile : artifact.getSourceFiles()) {
                    File parentFile = sourceFile.getFilePath().getParentFile();
                    if (parentFile == null) continue;
                    sourceFolders.add(parentFile);
                }
            }
            return ImmutableList.copyOf((Collection)sourceFolders);
        }
    }
}

