/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalAndroidModelView {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Tree myTree;

    public InternalAndroidModelView(@NotNull Project project) {
        this.myProject = project;
        this.myTree = new Tree();
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncStarted(@NotNull Project project) {
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                InternalAndroidModelView.this.updateContents();
            }
        });
    }

    public static InternalAndroidModelView getInstance(@NotNull Project project) {
        return (InternalAndroidModelView)ServiceManager.getService((Project)project, InternalAndroidModelView.class);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ToolWindowAlikePanel toolWindowPanel = ToolWindowAlikePanel.createTreePanel(this.myProject.getName(), (JTree)this.myTree);
        Content content = contentFactory.createContent((JComponent)toolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    private void updateContents() {
        this.myTree.setRootVisible(true);
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Gradle project sync in progress ...")));
            return;
        }
        this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Loading ...")));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.myProject.getName());
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                NativeAndroidGradleModel nativeAndroidModel;
                AndroidGradleModel androidModel = AndroidGradleModel.get(module);
                if (androidModel != null) {
                    DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(module.getName());
                    AndroidProject androidProject = androidModel.waitForAndGetProxyAndroidProject();
                    this.addProxyObject(moduleNode, androidProject);
                    rootNode.add(moduleNode);
                }
                if ((nativeAndroidModel = NativeAndroidGradleModel.get(module)) == null) continue;
                String nodeName = androidModel == null ? module.getName() : module.getName() + " (native)";
                DefaultMutableTreeNode nativeModuleNode = new DefaultMutableTreeNode(nodeName);
                NativeAndroidProject nativeAndroidProject = nativeAndroidModel.waitForAndGetProxyAndroidProject();
                this.addProxyObject(nativeModuleNode, nativeAndroidProject);
                rootNode.add(nativeModuleNode);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setOpenIcon(AllIcons.Nodes.NewFolder);
                renderer.setClosedIcon(AllIcons.Nodes.NewFolder);
                renderer.setLeafIcon(AllIcons.ObjectBrowser.ShowModules);
                this.myTree.setCellRenderer((TreeCellRenderer)renderer);
                DefaultTreeModel model = new DefaultTreeModel(rootNode);
                this.myTree.setRootVisible(false);
                this.myTree.setModel((TreeModel)model);
            });
        });
    }

    void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj) {
        this.addProxyObject(node, obj, false);
    }

    private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName) {
        assert (ProxyUtil.isAndroidModelProxyObject(obj));
        String name = null;
        for (Map.Entry<String, Object> entry : ProxyUtil.getAndroidModelProxyValues(obj).entrySet()) {
            String property = entry.getKey();
            property = property.substring(0, property.lastIndexOf(40));
            property = property.substring(property.lastIndexOf(46) + 1, property.length());
            property = StringUtil.trimStart((String)property, (String)"get");
            Object value = entry.getValue();
            if (value != null && property.equals("Name")) {
                name = value.toString();
            }
            this.addPropertyNode(node, property, value);
        }
        if (useDerivedNodeName && name != null) {
            node.setUserObject(name);
        }
    }

    private void addPropertyNode(@NotNull DefaultMutableTreeNode node, @NotNull String property, @Nullable Object value) {
        DefaultMutableTreeNode propertyNode = new DefaultMutableTreeNode(property);
        if (value != null && ProxyUtil.isAndroidModelProxyObject(value)) {
            this.addProxyObject(propertyNode, value, property.isEmpty());
        } else if (value instanceof Collection && !((Collection)value).isEmpty()) {
            for (Object obj : (Collection)value) {
                this.addPropertyNode(propertyNode, "", obj);
            }
        } else if (value instanceof Map && !((Map)value).isEmpty()) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                this.addPropertyNode(propertyNode, key.toString(), map.get(key));
            }
        } else if (value instanceof ProxyUtil.InvocationErrorValue) {
            Throwable exception = ((ProxyUtil.InvocationErrorValue)value).exception;
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, "Error: " + exception.getClass().getName()));
        } else {
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, this.getStringForValue(value)));
        }
        InternalAndroidModelView.addToNode(node, propertyNode);
    }

    @NotNull
    private String getStringForValue(@Nullable Object value) {
        if (value != null && value instanceof File) {
            String filePath = ((File)value).getPath();
            String basePath = this.myProject.getBasePath();
            if (basePath != null) {
                if (!(basePath = FileUtil.toSystemDependentName((String)basePath)).endsWith(File.separator)) {
                    basePath = basePath + File.separator;
                }
                if (filePath.startsWith(basePath)) {
                    return filePath.substring(basePath.length());
                }
            }
        }
        return value == null ? "null" : value.toString();
    }

    @NotNull
    private static String getNodeValue(@NotNull String property, @NotNull String value) {
        return property.isEmpty() ? value : property + " -> " + value;
    }

    private static void addToNode(@NotNull DefaultMutableTreeNode parent, @NotNull DefaultMutableTreeNode newChild) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode existingChild = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (InternalAndroidModelView.compareTo(existingChild, newChild) < 0) continue;
            parent.insert(newChild, i);
            return;
        }
        parent.add(newChild);
    }

    private static int compareTo(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2) {
        if (node1.isLeaf() && !node2.isLeaf()) {
            return -1;
        }
        if (!node1.isLeaf() && node2.isLeaf()) {
            return 1;
        }
        return node1.getUserObject().toString().compareTo(node2.getUserObject().toString());
    }
}

