/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.util.GradleUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleModelFeatures {
    @Nullable
    private final GradleVersion myModelVersion;
    private boolean myDependencyGraphSupported;
    private boolean myIssueReportingSupported;
    private boolean myShadersSupported;
    private boolean myTestedTargetVariantsSupported;
    private boolean myProductFlavorVersionSuffixSupported;
    private boolean myExternalBuildSupported;
    private boolean myConstraintLayoutSdkLocationSupported;

    GradleModelFeatures(@Nullable GradleVersion modelVersion) {
        this.myModelVersion = modelVersion;
        this.myDependencyGraphSupported = this.myModelVersion != null && GradleUtil.androidModelSupportsDependencyGraph(this.myModelVersion);
        this.myIssueReportingSupported = this.modelVersionIsAtLeast("1.1.0");
        this.myShadersSupported = this.modelVersionIsAtLeast("2.1.0");
        this.myConstraintLayoutSdkLocationSupported = this.myModelVersion != null && this.myModelVersion.compareTo("2.1.0") > 0;
        this.myProductFlavorVersionSuffixSupported = this.myExternalBuildSupported = this.modelVersionIsAtLeast("2.2.0");
        this.myTestedTargetVariantsSupported = this.myExternalBuildSupported;
    }

    private boolean modelVersionIsAtLeast(@NotNull String revision) {
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    public boolean isDependencyGraphSupported() {
        return this.myDependencyGraphSupported;
    }

    public boolean isIssueReportingSupported() {
        return this.myIssueReportingSupported;
    }

    public boolean isShadersSupported() {
        return this.myShadersSupported;
    }

    public boolean isTestedTargetVariantsSupported() {
        return this.myTestedTargetVariantsSupported;
    }

    public boolean isProductFlavorVersionSuffixSupported() {
        return this.myProductFlavorVersionSuffixSupported;
    }

    public boolean isExternalBuildSupported() {
        return this.myExternalBuildSupported;
    }

    public boolean isConstraintLayoutSdkLocationSupported() {
        return this.myConstraintLayoutSdkLocationSupported;
    }
}

