/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModelView {
    private static final ImmutableMultimap<String, String> SOURCE_PROVIDERS_GROUP = ImmutableMultimap.builder().putAll((Object)"SourceProviders", (Object[])new String[]{"SourceProvider", "ExtraSourceProviders"}).build();
    private static final ImmutableMultimap<String, String> SDK_VERSIONS_GROUP = ImmutableMultimap.builder().putAll((Object)"SdkVersions", (Object[])new String[]{"MinSdkVersion", "MaxSdkVersion", "TargetSdkVersion"}).build();
    private static final ImmutableMultimap<String, String> ARTIFACTS_GROUP = ImmutableMultimap.builder().putAll((Object)"Artifacts", (Object[])new String[]{"MainArtifact", "ExtraAndroidArtifacts", "ExtraJavaArtifacts"}).build();
    private static final ImmutableMultimap<String, String> JNI_DIRECTORIES_GROUP = ImmutableMultimap.builder().putAll((Object)"JniDirectories", (Object[])new String[]{"CDirectories"}).build();
    @NotNull
    private final Project myProject;
    @NotNull
    private final Tree myTree;

    public AndroidModelView(@NotNull Project project) {
        this.myProject = project;
        this.myTree = new Tree();
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncStarted(@NotNull Project project) {
                AndroidModelView.this.updateContents();
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                AndroidModelView.this.updateContents();
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                AndroidModelView.this.updateContents();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                AndroidModelView.this.updateContents();
            }
        });
    }

    public static AndroidModelView getInstance(@NotNull Project project) {
        return (AndroidModelView)ServiceManager.getService((Project)project, AndroidModelView.class);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ToolWindowAlikePanel toolWindowPanel = ToolWindowAlikePanel.createTreePanel(this.myProject.getName(), (JTree)this.myTree);
        Content content = contentFactory.createContent((JComponent)toolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    private void updateContents() {
        this.myTree.setRootVisible(true);
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Gradle project sync in progress ...")));
            return;
        }
        this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Loading ...")));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.myProject.getName());
            String projectPath = this.myProject.getBasePath();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidGradleModel androidModel = AndroidGradleModel.get(module);
                if (androidModel == null) continue;
                DefaultMutableTreeNode moduleNode = new ModuleNodeBuilder(module.getName(), androidModel, projectPath).getNode();
                rootNode.add(moduleNode);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setOpenIcon(AllIcons.Nodes.NewFolder);
                renderer.setClosedIcon(AllIcons.Nodes.NewFolder);
                renderer.setLeafIcon(AllIcons.ObjectBrowser.ShowModules);
                this.myTree.setCellRenderer((TreeCellRenderer)renderer);
                DefaultTreeModel model = new DefaultTreeModel(rootNode);
                this.myTree.setRootVisible(false);
                this.myTree.setModel((TreeModel)model);
            });
        });
    }

    static class ModuleNodeBuilder {
        @NotNull
        private final String myModuleName;
        @NotNull
        private final AndroidGradleModel myAndroidModel;
        @Nullable
        private final String myProjectPath;
        private List<DefaultMutableTreeNode> artifactNodes = Lists.newArrayList();

        public ModuleNodeBuilder(@NotNull String moduleName, @NotNull AndroidGradleModel androidModel, @Nullable String projectPath) {
            this.myModuleName = moduleName;
            this.myAndroidModel = androidModel;
            if (projectPath != null && !projectPath.endsWith(File.separator)) {
                projectPath = projectPath + File.separator;
            }
            this.myProjectPath = projectPath == null ? null : FileUtil.toSystemDependentName((String)projectPath);
        }

        public DefaultMutableTreeNode getNode() {
            DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(this.myModuleName);
            AndroidProject androidProject = this.myAndroidModel.waitForAndGetProxyAndroidProject();
            this.artifactNodes.clear();
            this.addProxyObject(moduleNode, androidProject, false, (Collection<String>)ImmutableList.of((Object)"SyncIssues", (Object)"UnresolvedDependencies", (Object)"ApiVersion"));
            this.artifactNodes.forEach(this::addSources);
            return moduleNode;
        }

        void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj) {
            this.addProxyObject(node, obj, false);
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName) {
            this.addProxyObject(node, obj, useDerivedNodeName, (Collection<String>)ImmutableList.of());
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName, @NotNull Collection<String> skipProperties) {
            this.addProxyObject(node, obj, useDerivedNodeName, skipProperties, (Collection<String>)ImmutableList.of(), (Multimap<String, String>)ImmutableMultimap.of());
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName, @NotNull Collection<String> inlineProperties, @NotNull Multimap<String, String> groupProperties) {
            this.addProxyObject(node, obj, useDerivedNodeName, (Collection<String>)ImmutableList.of(), inlineProperties, groupProperties);
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName, @NotNull Collection<String> skipProperties, @NotNull Collection<String> inlineProperties, @NotNull Multimap<String, String> groupProperties) {
            assert (ProxyUtil.isAndroidModelProxyObject(obj));
            HashMap groupPropertyNodes = Maps.newHashMap();
            String name = null;
            for (Map.Entry<String, Object> entry : ProxyUtil.getAndroidModelProxyValues(obj).entrySet()) {
                String property = entry.getKey();
                property = property.substring(0, property.lastIndexOf(40));
                property = property.substring(property.lastIndexOf(46) + 1, property.length());
                if (skipProperties.contains(property = StringUtil.trimStart((String)property, (String)"get"))) continue;
                boolean useDerivedNameValue = false;
                boolean addToParentNode = false;
                Object value = entry.getValue();
                if (value != null && property.equals("Name")) {
                    name = value.toString();
                }
                if (inlineProperties.contains(property)) {
                    addToParentNode = true;
                    useDerivedNameValue = useDerivedNodeName;
                }
                DefaultMutableTreeNode parentNode = node;
                if (groupProperties.values().contains(property)) {
                    for (Map.Entry group : groupProperties.entries()) {
                        if (!((String)group.getValue()).equals(property)) continue;
                        String groupName = (String)group.getKey();
                        DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupPropertyNodes.get(groupName);
                        if (groupNode == null) {
                            groupNode = new DefaultMutableTreeNode(groupName);
                            groupPropertyNodes.put(groupName, groupNode);
                        }
                        parentNode = groupNode;
                        useDerivedNameValue = true;
                        break;
                    }
                }
                this.addPropertyNode(parentNode, property, value, useDerivedNameValue, addToParentNode);
            }
            for (DefaultMutableTreeNode groupNode : groupPropertyNodes.values()) {
                ModuleNodeBuilder.addToNode(node, groupNode);
            }
            if (useDerivedNodeName && name != null) {
                node.setUserObject(name);
            }
        }

        private void addPropertyNode(@NotNull DefaultMutableTreeNode node, @NotNull String property, @Nullable Object value, boolean useDerivedNodeName, boolean addToParentNode) {
            DefaultMutableTreeNode propertyNode;
            DefaultMutableTreeNode defaultMutableTreeNode = propertyNode = addToParentNode ? node : new DefaultMutableTreeNode(property);
            if (value != null && ProxyUtil.isAndroidModelProxyObject(value)) {
                if (!this.customizeProxyObject(propertyNode, value, useDerivedNodeName)) {
                    this.addProxyObject(propertyNode, value, useDerivedNodeName);
                }
            } else if (value instanceof Collection && (!((Collection)value).isEmpty() || addToParentNode)) {
                for (Object obj : (Collection)value) {
                    this.addPropertyNode(propertyNode, "", obj, true, false);
                }
            } else if (value instanceof Map && (!((Map)value).isEmpty() || addToParentNode)) {
                Map map = (Map)value;
                for (Object key : map.keySet()) {
                    this.addPropertyNode(propertyNode, key.toString(), map.get(key), false, false);
                }
            } else if (value instanceof ProxyUtil.InvocationErrorValue) {
                Throwable exception = ((ProxyUtil.InvocationErrorValue)value).exception;
                propertyNode.setUserObject(ModuleNodeBuilder.getNodeValue(property, "Error: " + exception.getClass().getName()));
            } else {
                propertyNode.setUserObject(ModuleNodeBuilder.getNodeValue(property, this.getStringForValue(value)));
            }
            if (!addToParentNode) {
                ModuleNodeBuilder.addToNode(node, propertyNode);
            }
        }

        private boolean customizeProxyObject(@NotNull DefaultMutableTreeNode propertyNode, @NotNull Object value, boolean useDerivedName) {
            assert (ProxyUtil.isAndroidModelProxyObject(value));
            if (value instanceof ProductFlavorContainer) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"ProductFlavor", (Object)"ExtraSourceProviders"), (Multimap<String, String>)SOURCE_PROVIDERS_GROUP);
            } else if (value instanceof BuildTypeContainer) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"BuildType", (Object)"ExtraSourceProviders"), (Multimap<String, String>)SOURCE_PROVIDERS_GROUP);
            } else if (value instanceof SourceProviderContainer) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"SourceProvider"), (Multimap<String, String>)ImmutableMultimap.of());
            } else if (value instanceof SourceProvider) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"CppDirectories"), (Collection<String>)ImmutableList.of((Object)"CDirectories"), (Multimap<String, String>)JNI_DIRECTORIES_GROUP);
            } else if (value instanceof ProductFlavor) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of(), (Multimap<String, String>)SDK_VERSIONS_GROUP);
            } else if (value instanceof Variant) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of(), (Collection<String>)ImmutableList.of((Object)"ExtraAndroidArtifacts", (Object)"ExtraJavaArtifacts"), (Multimap<String, String>)ARTIFACTS_GROUP);
            } else if (value instanceof BaseArtifact) {
                this.addProxyObject(propertyNode, value, useDerivedName);
                this.artifactNodes.add(propertyNode);
            } else {
                return false;
            }
            return true;
        }

        private void addSources(@NotNull DefaultMutableTreeNode artifactNode) {
            String artifactName = artifactNode.getUserObject().toString();
            String variantName = ((DefaultMutableTreeNode)artifactNode.getParent().getParent()).getUserObject().toString();
            List<SourceProvider> sourceProviders = artifactName.equals("_main_") ? this.myAndroidModel.getMainSourceProviders(variantName) : this.myAndroidModel.getTestSourceProviders(variantName, artifactName);
            DefaultMutableTreeNode sourcesNode = new DefaultMutableTreeNode("Sources");
            this.addSourceProviders(sourcesNode, sourceProviders);
            ModuleNodeBuilder.addToNode(artifactNode, sourcesNode);
        }

        private void addSourceProviders(@NotNull DefaultMutableTreeNode sourcesNode, @NotNull List<SourceProvider> sourceProviders) {
            DefaultMutableTreeNode manifestFilesNode = new DefaultMutableTreeNode("ManifestFiles");
            DefaultMutableTreeNode javaDirectoriesNode = new DefaultMutableTreeNode("JavaDirectories");
            DefaultMutableTreeNode jniDirectoriesNode = new DefaultMutableTreeNode("JniDirectories");
            DefaultMutableTreeNode jniLibsDirectoriesNode = new DefaultMutableTreeNode("JniLibsDirectories");
            DefaultMutableTreeNode resDirectoriesNode = new DefaultMutableTreeNode("ResDirectories");
            DefaultMutableTreeNode aidlDirectoriesNode = new DefaultMutableTreeNode("AidlDirectories");
            DefaultMutableTreeNode resourcesDirectoriesNode = new DefaultMutableTreeNode("ResourcesDirectories");
            DefaultMutableTreeNode assetsDirectoriesNode = new DefaultMutableTreeNode("AssetsDirectories");
            DefaultMutableTreeNode renderscriptDirectoriesNode = new DefaultMutableTreeNode("RenderscriptDirectories");
            for (SourceProvider sourceProvider : sourceProviders) {
                this.addFiles(manifestFilesNode, (Collection<File>)ImmutableList.of((Object)sourceProvider.getManifestFile()));
                this.addFiles(javaDirectoriesNode, sourceProvider.getJavaDirectories());
                this.addFiles(jniDirectoriesNode, sourceProvider.getCDirectories());
                this.addFiles(jniLibsDirectoriesNode, sourceProvider.getJniLibsDirectories());
                this.addFiles(resDirectoriesNode, sourceProvider.getResDirectories());
                this.addFiles(aidlDirectoriesNode, sourceProvider.getAidlDirectories());
                this.addFiles(resourcesDirectoriesNode, sourceProvider.getResourcesDirectories());
                this.addFiles(assetsDirectoriesNode, sourceProvider.getAssetsDirectories());
                this.addFiles(renderscriptDirectoriesNode, sourceProvider.getRenderscriptDirectories());
            }
            sourcesNode.add(manifestFilesNode);
            sourcesNode.add(javaDirectoriesNode);
            sourcesNode.add(jniDirectoriesNode);
            sourcesNode.add(jniLibsDirectoriesNode);
            sourcesNode.add(resDirectoriesNode);
            sourcesNode.add(aidlDirectoriesNode);
            sourcesNode.add(resourcesDirectoriesNode);
            sourcesNode.add(assetsDirectoriesNode);
            sourcesNode.add(renderscriptDirectoriesNode);
        }

        private void addFiles(@NotNull DefaultMutableTreeNode node, Collection<File> files) {
            for (File file : files) {
                node.add(new DefaultMutableTreeNode(this.getStringForValue(file)));
            }
        }

        @NotNull
        private String getStringForValue(@Nullable Object value) {
            if (value != null && value instanceof File) {
                String filePath = ((File)value).getPath();
                if (this.myProjectPath != null && filePath.startsWith(this.myProjectPath)) {
                    return filePath.substring(this.myProjectPath.length());
                }
            }
            return value == null ? "null" : value.toString();
        }

        @NotNull
        private static String getNodeValue(@NotNull String property, @NotNull String value) {
            return property.isEmpty() ? value : property + " -> " + value;
        }

        private static void addToNode(@NotNull DefaultMutableTreeNode parent, @NotNull DefaultMutableTreeNode newChild) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DefaultMutableTreeNode existingChild = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (ModuleNodeBuilder.compareTo(existingChild, newChild) < 0) continue;
                parent.insert(newChild, i);
                return;
            }
            parent.add(newChild);
        }

        private static int compareTo(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2) {
            if (node1.isLeaf() && !node2.isLeaf()) {
                return -1;
            }
            if (!node1.isLeaf() && node2.isLeaf()) {
                return 1;
            }
            return node1.getUserObject().toString().compareTo(node2.getUserObject().toString());
        }
    }
}

