/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.fd.RunAsValidator;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RunAsValidityService
implements RunAsValidator {
    private static final Map<String, Boolean> ourRunAsStateByDevice = Maps.newConcurrentMap();

    public static RunAsValidityService getInstance() {
        return (RunAsValidityService)ServiceManager.getService(RunAsValidityService.class);
    }

    private RunAsValidityService() {
    }

    @Override
    public boolean hasWorkingRunAs(@NotNull IDevice device, @NotNull String applicationId) {
        if (device.isEmulator()) {
            return true;
        }
        Boolean workingRunAs = ourRunAsStateByDevice.get(device.getSerialNumber());
        if (workingRunAs == null) {
            workingRunAs = RunAsValidityService.checkForWorkingRunAs(device, applicationId);
            ourRunAsStateByDevice.put(device.getSerialNumber(), workingRunAs);
        }
        return workingRunAs != null && workingRunAs != false;
    }

    private static Boolean checkForWorkingRunAs(@NotNull IDevice device, @NotNull String applicationId) {
        String cmd = "run-as " + applicationId + " ls";
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            device.executeShellCommand(cmd, (IShellOutputReceiver)receiver, 2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return null;
        }
        String runAsOutput = receiver.getOutput();
        Logger.getInstance(RunAsValidityService.class).info("Output of " + cmd + ": " + runAsOutput);
        return !runAsOutput.contains("run-as: Package") && !runAsOutput.contains("run-as: Could not set capabilities");
    }
}

