/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunNotificationProvider;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.DexDeployTask;
import com.android.tools.idea.run.tasks.HotSwapTask;
import com.android.tools.idea.run.tasks.InstantRunNotificationTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.NoChangesTask;
import com.android.tools.idea.run.tasks.SplitApkDeployTask;
import com.android.tools.idea.run.tasks.UpdateInstantRunStateTask;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuildAnalyzer {
    private final Project myProject;
    private final InstantRunContext myContext;
    private final ProcessHandler myCurrentSession;
    private final InstantRunBuildInfo myBuildInfo;

    public InstantRunBuildAnalyzer(@NotNull Project project, @NotNull InstantRunContext context, @Nullable ProcessHandler currentSession) {
        this.myProject = project;
        this.myContext = context;
        this.myCurrentSession = currentSession;
        this.myBuildInfo = this.myContext.getInstantRunBuildInfo();
        if (this.myBuildInfo == null) {
            throw new IllegalArgumentException("Instant Run Build Information must be available post build");
        }
        if (!this.myBuildInfo.isCompatibleFormat()) {
            throw new IllegalStateException("This version of Android Studio is incompatible with the Gradle Plugin used. Try disabling Instant Run (or updating either the IDE or the Gradle plugin to the latest version)");
        }
    }

    public boolean canReuseProcessHandler() {
        if (this.myCurrentSession == null || this.myCurrentSession.isProcessTerminated()) {
            return false;
        }
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        assert (buildSelection != null) : "Build must have completed before results are analyzed";
        return buildSelection.mode == BuildMode.HOT && (this.myBuildInfo.hasNoChanges() || this.myBuildInfo.canHotswap());
    }

    @NotNull
    public List<LaunchTask> getDeployTasks(@Nullable LaunchOptions launchOptions) throws ExecutionException {
        UpdateInstantRunStateTask updateStateTask = new UpdateInstantRunStateTask(this.myContext);
        DeployType deployType = this.getDeployType();
        switch (deployType) {
            case NO_CHANGES: {
                return ImmutableList.of((Object)new NoChangesTask(this.myProject, this.myContext), (Object)updateStateTask);
            }
            case HOTSWAP: 
            case WARMSWAP: {
                return ImmutableList.of((Object)new HotSwapTask(this.myProject, this.myContext, deployType == DeployType.WARMSWAP), (Object)updateStateTask);
            }
            case SPLITAPK: {
                return ImmutableList.of((Object)new SplitApkDeployTask(this.myProject, this.myContext), (Object)updateStateTask);
            }
            case DEX: {
                return ImmutableList.of((Object)new DexDeployTask(this.myProject, this.myContext), (Object)updateStateTask);
            }
            case FULLAPK: {
                Preconditions.checkNotNull((Object)launchOptions);
                DeployApkTask deployApkTask = new DeployApkTask(this.myProject, launchOptions, InstantRunBuildAnalyzer.getApks(this.myBuildInfo, this.myContext), this.myContext);
                return ImmutableList.of((Object)deployApkTask, (Object)updateStateTask);
            }
        }
        throw new IllegalStateException("Unhandled deploy type: " + (Object)((Object)deployType));
    }

    @NotNull
    public LaunchTask getNotificationTask() {
        DeployType deployType = this.getDeployType();
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        InstantRunNotificationProvider notificationProvider = new InstantRunNotificationProvider(buildSelection, deployType, this.myBuildInfo.getVerifierStatus());
        return new InstantRunNotificationTask(this.myProject, this.myContext, notificationProvider, buildSelection.brokenForSecondaryUser);
    }

    @NotNull
    private DeployType getDeployType() {
        List artifacts;
        if (this.canReuseProcessHandler()) {
            if (this.myBuildInfo.hasNoChanges()) {
                return DeployType.NO_CHANGES;
            }
            if (this.myBuildInfo.canHotswap()) {
                return InstantRunSettings.isRestartActivity() ? DeployType.WARMSWAP : DeployType.HOTSWAP;
            }
        }
        if ((artifacts = this.myBuildInfo.getArtifacts()).isEmpty()) {
            return DeployType.NO_CHANGES;
        }
        if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT}) || this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT_MAIN})) {
            return DeployType.SPLITAPK;
        }
        if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.DEX, InstantRunArtifactType.RESOURCES})) {
            return DeployType.DEX;
        }
        return DeployType.FULLAPK;
    }

    private static Collection<ApkInfo> getApks(@NotNull InstantRunBuildInfo buildInfo, @NotNull InstantRunContext context) throws ExecutionException {
        SmartList apks = new SmartList();
        for (InstantRunArtifact artifact : buildInfo.getArtifacts()) {
            if (artifact.type != InstantRunArtifactType.MAIN) {
                String msg = "Expected to only find apks, but got : " + artifact.type + "\n";
                BuildSelection buildSelection = context.getBuildSelection();
                assert (buildSelection != null) : "Build must have completed before apks are obtained";
                msg = buildSelection.mode == BuildMode.HOT ? msg + "Could not use hot-swap artifacts when there is no existing session." : msg + "Unexpected artifacts for build mode: " + (Object)((Object)buildSelection.mode);
                InstantRunManager.LOG.error(msg);
                throw new ExecutionException(msg);
            }
            apks.add(new ApkInfo(artifact.file, context.getApplicationId()));
        }
        return apks;
    }
}

