/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorContext
implements Disposable {
    @NotNull
    private Configuration myConfiguration;
    @Nullable
    private ConfiguredThemeEditorStyle myCurrentTheme;
    @NotNull
    private ThemeResolver myThemeResolver;
    private final List<ChangeListener> myChangeListeners = new ArrayList<ChangeListener>();
    private final List<ConfigurationListener> myConfigurationListeners = new ArrayList<ConfigurationListener>();
    private boolean myEnabledListeners = true;
    private final ConfigurationListener myConfigurationListener = new ConfigurationListener(){

        @Override
        public boolean changed(int flags) {
            if (!ThemeEditorContext.this.myEnabledListeners) {
                return true;
            }
            boolean accepted = true;
            for (ConfigurationListener listener : ThemeEditorContext.this.myConfigurationListeners) {
                accepted &= listener.changed(flags);
            }
            return accepted;
        }
    };

    public ThemeEditorContext(@NotNull Configuration configuration) {
        this.setConfiguration(configuration);
        this.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((0xF6 & flags) != 0) {
                    ThemeEditorContext.this.updateThemeResolver();
                }
                return true;
            }
        });
    }

    public void updateThemeResolver() {
        this.myEnabledListeners = false;
        Configuration resolverConfiguration = this.myConfiguration.clone();
        resolverConfiguration.setTheme(null);
        this.myEnabledListeners = true;
        this.myThemeResolver = new ThemeResolver(resolverConfiguration);
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public Module getCurrentContextModule() {
        return this.myConfiguration.getModule();
    }

    public void setCurrentTheme(@Nullable ConfiguredThemeEditorStyle currentTheme) {
        this.myCurrentTheme = currentTheme;
    }

    @Nullable
    public ConfiguredThemeEditorStyle getCurrentTheme() {
        return this.myCurrentTheme;
    }

    @NotNull
    public Module getModuleForResources() {
        if (this.myCurrentTheme != null && this.myCurrentTheme.getSourceModule() != null) {
            return this.myCurrentTheme.getSourceModule();
        }
        return this.myConfiguration.getModule();
    }

    public void setCurrentContextModule(@NotNull Module module) {
        this.setConfiguration(ThemeEditorUtils.getConfigurationForModule(module));
    }

    @Nullable(value="if there is no theme selected or the current selected module is not valid")
    public ResourceResolver getResourceResolver() {
        if (this.getCurrentContextModule().isDisposed()) {
            return null;
        }
        return this.myConfiguration.getResourceResolver();
    }

    @NotNull
    public Project getProject() {
        return this.myConfiguration.getModule().getProject();
    }

    public void addConfigurationListener(@NotNull ConfigurationListener configurationListener) {
        this.myConfigurationListeners.add(configurationListener);
    }

    @NotNull
    public ThemeResolver getThemeResolver() {
        return this.myThemeResolver;
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        if (this.myConfiguration != null) {
            this.myConfiguration.removeListener(this.myConfigurationListener);
        }
        this.myConfiguration = configuration;
        this.updateThemeResolver();
        this.myConfiguration.addListener(this.myConfigurationListener);
        this.fireNewConfiguration();
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    private void fireNewConfiguration() {
        for (ChangeListener listener : this.myChangeListeners) {
            listener.onNewConfiguration(this);
        }
    }

    public void dispose() {
        this.myConfiguration.removeListener(this.myConfigurationListener);
        this.myConfigurationListeners.clear();
    }

    public static interface ChangeListener {
        public void onNewConfiguration(ThemeEditorContext var1);
    }
}

