/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    @NotNull
    public static String getStyleResourceUrl(@NotNull String qualifiedName) {
        return ResolutionUtils.getResourceUrlFromQualifiedName(qualifiedName, "style");
    }

    public static String getResourceUrlFromQualifiedName(@NotNull String qualifiedName, @NotNull String type) {
        String startChar = "attr".equals(type) ? "?" : "@";
        int colonIndex = qualifiedName.indexOf(58);
        if (colonIndex != -1) {
            String namespace = qualifiedName.substring(0, colonIndex + 1);
            String themeNameWithoutNamespace = StringUtil.trimStart((String)qualifiedName, (String)namespace);
            return startChar + namespace + type + "/" + themeNameWithoutNamespace;
        }
        return startChar + type + "/" + qualifiedName;
    }

    @NotNull
    public static String getQualifiedNameFromResourceUrl(@NotNull String styleResourceUrl) {
        ResourceUrl url = ResourceUrl.parse((String)styleResourceUrl);
        assert (url != null) : styleResourceUrl;
        return url.namespace != null ? url.namespace + ':' + url.name : url.name;
    }

    @NotNull
    public static String getNameFromQualifiedName(@NotNull String qualifiedName) {
        int colonIndex = qualifiedName.indexOf(58);
        return colonIndex != -1 ? qualifiedName.substring(colonIndex + 1) : qualifiedName;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        String name = style.getName();
        return style.isFramework() ? "android:" + name : name;
    }

    @NotNull
    public static String getQualifiedItemName(@NotNull ItemResourceValue item) {
        String name = item.getName();
        return item.isFrameworkAttr() ? "android:" + name : name;
    }

    @NotNull
    public static String getQualifiedValue(@NotNull ItemResourceValue item) {
        ResourceUrl url = ResourceUrl.parse((String)item.getRawXmlValue(), (boolean)item.isFramework());
        return url == null ? item.getRawXmlValue() : url.toString();
    }

    @Nullable
    private static StyleResourceValue getStyleResourceValue(@NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName) {
        boolean isFrameworkStyle;
        String styleName;
        assert (!qualifiedStyleName.startsWith("@android:style/"));
        assert (!qualifiedStyleName.startsWith("@style/"));
        if (qualifiedStyleName.startsWith("android:")) {
            styleName = qualifiedStyleName.substring("android:".length());
            isFrameworkStyle = true;
        } else {
            styleName = qualifiedStyleName;
            isFrameworkStyle = false;
        }
        return resolver.getStyle(styleName, isFrameworkStyle);
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName, @Nullable Module module) {
        StyleResourceValue style = ResolutionUtils.getStyleResourceValue(resolver, qualifiedStyleName);
        return style == null ? null : new ConfiguredThemeEditorStyle(configuration, style, module);
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull String qualifiedStyleName, @Nullable Module module) {
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        return ResolutionUtils.getStyle(configuration, configuration.getResourceResolver(), qualifiedStyleName, module);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull ItemResourceValue itemResValue) {
        return ResolutionUtils.getAttributeDefinition(configuration.getModule(), configuration, ResolutionUtils.getQualifiedItemName(itemResValue));
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinitions definitions;
        if (name.startsWith("android:")) {
            IAndroidTarget target;
            if (configuration == null) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                assert (facet != null);
                target = facet.getConfigurationManager().getDefaultTarget();
            } else {
                target = configuration.getRealTarget();
            }
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = facet.getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(ResolutionUtils.getNameFromQualifiedName(name));
    }

    public static int getOriginalApiLevel(@Nullable String name, @NotNull Project project) {
        if (name == null) {
            return -1;
        }
        ApiLookup apiLookup = IntellijLintClient.getApiLookup(project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        ResourceUrl resUrl = ResourceUrl.parse((String)name);
        if (resUrl == null) {
            if (!name.startsWith("android:")) {
                return -1;
            }
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        if (!resUrl.framework) {
            return -1;
        }
        return apiLookup.getFieldVersion("android/R$" + resUrl.type, AndroidResourceUtil.getFieldNameByResourceName(resUrl.name));
    }

    @Nullable(value="if this style doesn't have parent")
    public static String getParentQualifiedName(@NotNull StyleResourceValue style) {
        String parentName = ResourceResolver.getParentName((StyleResourceValue)style);
        if (parentName == null) {
            return null;
        }
        if (parentName.startsWith("@")) {
            parentName = ResolutionUtils.getQualifiedNameFromResourceUrl(parentName);
        }
        if (style.isFramework() && !parentName.startsWith("android:")) {
            parentName = "android:" + parentName;
        }
        return parentName;
    }

    @NotNull
    public static Collection<ItemResourceValue> getThemeAttributes(@NotNull ResourceResolver resolver, @NotNull String themeUrl) {
        StyleResourceValue theme;
        HashMap<String, ItemResourceValue> allItems = new HashMap<String, ItemResourceValue>();
        String themeName = ResolutionUtils.getQualifiedNameFromResourceUrl(themeUrl);
        while ((theme = resolver.getStyle(ResolutionUtils.getNameFromQualifiedName(themeName), themeName.startsWith("android:"))) != null) {
            Collection themeItems = theme.getValues();
            for (ItemResourceValue item : themeItems) {
                String itemName = ResolutionUtils.getQualifiedItemName(item);
                if (allItems.containsKey(itemName)) continue;
                allItems.put(itemName, item);
            }
            themeName = ResolutionUtils.getParentQualifiedName(theme);
            if (themeName != null) continue;
        }
        return allItems.values();
    }

    @Nullable(value="if we can't work out the type, e.g a 'reference' with a '@null' value or enum")
    public static ResourceType getAttrType(@NotNull ItemResourceValue item, @NotNull Configuration configuration) {
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)item);
        ResourceType attrType = resolvedValue.getResourceType();
        if (attrType != null) {
            return attrType;
        }
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(configuration, item);
        if (def != null) {
            for (AttributeFormat attrFormat : def.getFormats()) {
                attrType = AndroidDomUtil.getResourceType(attrFormat);
                if (attrType == null) continue;
                return attrType;
            }
        }
        return null;
    }

    @NotNull
    public static FolderConfiguration getFolderConfiguration(@NotNull AndroidFacet facet, @NotNull ResourceValue resolvedValue, @NotNull FolderConfiguration configuration) {
        List configurables;
        if (resolvedValue.isFramework()) {
            ConfigurationManager configurationManager = facet.getConfigurationManager();
            IAndroidTarget target = configurationManager.getDefaultTarget();
            assert (target != null);
            ResourceRepository resourceRepository = configurationManager.getResolverCache().getFrameworkResources(configuration, target);
            assert (resourceRepository != null);
            ResourceItem resourceItem = resourceRepository.getResourceItem(resolvedValue.getResourceType(), resolvedValue.getName());
            configurables = resourceItem.getSourceFileList();
        } else {
            AppResourceRepository appResourceRepository = facet.getAppResources(true);
            configurables = appResourceRepository.getResourceItem(resolvedValue.getResourceType(), resolvedValue.getName());
        }
        Configurable configurable = configuration.findMatchingConfigurable(configurables);
        assert (configurable != null);
        return configurable.getConfiguration();
    }
}

