/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.table.ConstantColumn;
import com.android.tools.idea.editors.strings.table.HeaderCellRenderer;
import com.android.tools.idea.rendering.Locale;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class TranslationHeaderCellRenderer
implements HeaderCellRenderer {
    private final Locale myLocale;
    private boolean myBrief;
    private final int myCollapsedWidth;
    private final int myExpandedWidth;
    private final int myNameSwitchWidth;

    public TranslationHeaderCellRenderer(@NotNull FontMetrics metrics, @NotNull Locale locale) {
        this.myLocale = locale;
        this.myCollapsedWidth = 20 + metrics.stringWidth(this.myLocale.getFlagImage().getIconWidth() + LocaleMenuAction.getLocaleLabel(this.myLocale, true));
        this.myExpandedWidth = 20 + metrics.stringWidth(String.valueOf(ConstantColumn.DEFAULT_VALUE.sampleData));
        this.myNameSwitchWidth = 20 + metrics.stringWidth(this.myLocale.getFlagImage().getIconWidth() + LocaleMenuAction.getLocaleLabel(this.myLocale, false));
        this.myBrief = true;
    }

    @Override
    public int getCollapsedWidth() {
        return this.myCollapsedWidth;
    }

    @Override
    public int getFullExpandedWidth() {
        return this.myExpandedWidth;
    }

    @Override
    public int getMinimumExpandedWidth() {
        return this.myNameSwitchWidth;
    }

    public void setUseBriefName(boolean brief) {
        this.myBrief = brief;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        TableCellRenderer defaultRenderer = table.getTableHeader().getDefaultRenderer();
        Component component = defaultRenderer.getTableCellRendererComponent(table, value, selected, focused, row, column);
        if (component instanceof JLabel) {
            JLabel labelComponent = (JLabel)component;
            labelComponent.setIcon(this.myLocale.getFlagImage());
            labelComponent.setText(LocaleMenuAction.getLocaleLabel(this.myLocale, this.myBrief));
        }
        return component;
    }
}

