/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.ConstantColumn;
import com.android.tools.idea.rendering.Locale;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceTableModel
extends AbstractTableModel {
    @Nullable
    private StringResourceData myData;

    public void setData(@NotNull StringResourceData data) {
        this.myData = data;
    }

    @NotNull
    public String keyOfRow(int row) {
        return this.myData == null ? "" : this.myData.getKeys().get(row);
    }

    @Nullable
    public Locale localeOfColumn(int column) {
        return column < ConstantColumn.COUNT || this.myData == null ? null : this.myData.getLocales().get(column - ConstantColumn.COUNT);
    }

    @Override
    public int getRowCount() {
        return this.myData == null ? 0 : this.myData.getKeys().size();
    }

    @Override
    public int getColumnCount() {
        return this.myData == null ? 0 : this.myData.getLocales().size() + ConstantColumn.COUNT;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        assert (this.myData != null);
        if (ConstantColumn.KEY.ordinal() == column) {
            this.myData.changeKeyName(row, (String)value);
            this.fireTableRowsUpdated(0, this.myData.getKeys().size());
        } else if (ConstantColumn.UNTRANSLATABLE.ordinal() == column) {
            Boolean doNotTranslate = (Boolean)value;
            if (this.myData.setDoNotTranslate(this.keyOfRow(row), doNotTranslate)) {
                this.fireTableCellUpdated(row, column);
            }
        } else if (this.myData.setTranslation(this.keyOfRow(row), this.localeOfColumn(column), (String)value)) {
            this.fireTableCellUpdated(row, column);
        }
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        if (this.myData == null) {
            return "";
        }
        String key = this.keyOfRow(row);
        if (column >= ConstantColumn.COUNT) {
            Locale locale = this.localeOfColumn(column);
            return locale == null ? "" : this.myData.resourceToString(key, locale);
        }
        switch (ConstantColumn.values()[column]) {
            case KEY: {
                return key;
            }
            case DEFAULT_VALUE: {
                return this.myData.resourceToString(key);
            }
            case UNTRANSLATABLE: {
                return this.myData.getUntranslatableKeys().contains(key);
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        if (column >= ConstantColumn.COUNT) {
            return LocaleMenuAction.getLocaleLabel(this.localeOfColumn(column), false);
        }
        return ConstantColumn.values()[column].name;
    }

    public Class getColumnClass(int column) {
        if (column >= ConstantColumn.COUNT) {
            return ConstantColumn.DEFAULT_VALUE.sampleData.getClass();
        }
        return ConstantColumn.values()[column].sampleData.getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Nullable
    public String getCellProblem(int row, int column) {
        if (this.myData == null) {
            return null;
        }
        String key = this.keyOfRow(row);
        if (ConstantColumn.KEY.ordinal() == column) {
            return this.myData.validateKey(key);
        }
        Locale l = this.localeOfColumn(column);
        return this.myData.validateTranslation(key, l);
    }
}

