/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.ColumnUtil;
import com.android.tools.idea.editors.strings.table.HeaderCellRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class HeaderCellSelectionListener
extends MouseAdapter {
    private final JTable myTable;
    private int myUserResizeIndex;

    public HeaderCellSelectionListener(@NotNull JTable table) {
        this.myTable = table;
        this.myUserResizeIndex = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ColumnUtil.expandToViewportWidthIfNecessary(this.myTable, this.myUserResizeIndex);
        this.myUserResizeIndex = -1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int index = this.myTable.columnAtPoint(e.getPoint());
        TableColumn column = this.myTable.getColumnModel().getColumn(index);
        HeaderCellRenderer renderer = (HeaderCellRenderer)column.getHeaderRenderer();
        boolean useCollapsedWidth = column.getWidth() >= renderer.getMinimumExpandedWidth();
        ColumnUtil.setPreferredWidth(column, useCollapsedWidth ? renderer.getCollapsedWidth() : renderer.getFullExpandedWidth());
        ColumnUtil.expandToViewportWidthIfNecessary(this.myTable, index);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TableColumn column = this.myTable.getTableHeader().getResizingColumn();
        if (column != null) {
            this.myUserResizeIndex = column.getModelIndex();
            ColumnUtil.setPreferredWidth(column, column.getWidth());
        }
    }
}

