/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.tools.idea.editors.manifest.AnnotationColors;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.NamedObject;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.utils.HtmlBuilder;
import com.android.utils.PositionXmlParser;
import com.google.common.collect.Sets;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestPanel
extends JPanel
implements TreeSelectionListener {
    private static final String SUGGESTION_MARKER = "Suggestion: ";
    private static final Pattern ADD_SUGGESTION_FORMAT = Pattern.compile(".*? 'tools:([\\w:]+)=\"([\\w:]+)\"' to \\<(\\w+)\\> element at [^:]+:(\\d+):(\\d+)-[\\d:]+ to override\\.", 32);
    private final AndroidFacet myFacet;
    private final Font myDefaultFont;
    private Tree myTree;
    private JEditorPane myDetails;
    private JPopupMenu myPopup;
    private JMenuItem myRemoveItem;
    private JMenuItem myGotoItem;
    private MergedManifest myManifest;
    private final List<File> myFiles = new ArrayList<File>();
    private final List<File> myOtherFiles = new ArrayList<File>();
    private final HtmlLinkManager myHtmlLinkManager = new HtmlLinkManager();
    private VirtualFile myFile;
    private final Color myBackgroundColor;
    private static final Comparator<File> MANIFEST_SORTER = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            boolean lib2;
            String p1 = o1.getPath();
            String p2 = o2.getPath();
            boolean lib1 = p1.contains("exploded-aar");
            if (lib1 != (lib2 = p2.contains("exploded-aar"))) {
                return lib1 ? 1 : -1;
            }
            return p1.compareTo(p2);
        }
    };

    public ManifestPanel(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        this.setLayout(new BorderLayout());
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        this.myBackgroundColor = scheme.getDefaultBackground();
        this.myDefaultFont = scheme.getFont(EditorFontType.PLAIN);
        this.myTree = new FileColorTree();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new SyntaxHighlightingCellRenderer()));
        TreeSelectionModel selectionModel = this.myTree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        selectionModel.addTreeSelectionListener(this);
        this.myDetails = this.createDetailsPane(facet);
        this.addSpeedSearch();
        this.createPopupMenu();
        this.registerGotoAction();
        JBSplitter splitter = new JBSplitter(0.5f);
        splitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myTree));
        splitter.setSecondComponent((JComponent)new JBScrollPane((Component)this.myDetails));
        this.add((Component)splitter);
    }

    private JEditorPane createDetailsPane(final @NotNull AndroidFacet facet) {
        JEditorPane details = new JEditorPane();
        details.setMargin(new Insets(5, 5, 5, 5));
        details.setContentType("text/html");
        details.setEditable(false);
        details.setFont(this.myDefaultFont);
        details.setBackground(this.myBackgroundColor);
        HyperlinkListener hyperLinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = e.getDescription();
                    ManifestPanel.this.myHtmlLinkManager.handleUrl(url, facet.getModule(), null, null, null);
                }
            }
        };
        details.addHyperlinkListener(hyperLinkListener);
        return details;
    }

    private void createPopupMenu() {
        this.myPopup = new JBPopupMenu();
        this.myGotoItem = new JBMenuItem("Go to Declaration");
        this.myGotoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                TreePath treePath = ManifestPanel.this.myTree.getSelectionPath();
                ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
                if (node != null) {
                    ManifestPanel.this.goToDeclaration(node.getUserObject());
                }
            }
        });
        this.myPopup.add(this.myGotoItem);
        this.myRemoveItem = new JBMenuItem("Remove");
        this.myRemoveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                TreePath treePath = ManifestPanel.this.myTree.getSelectionPath();
                final ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
                new WriteCommandAction.Simple(ManifestPanel.this.myFacet.getModule().getProject(), "Removing manifest tag", new PsiFile[]{ManifestUtils.getMainManifest(ManifestPanel.this.myFacet)}){

                    protected void run() throws Throwable {
                        ManifestUtils.toolsRemove(ManifestUtils.getMainManifest(ManifestPanel.this.myFacet), node.getUserObject());
                    }
                }.execute();
            }
        });
        this.myPopup.add(this.myRemoveItem);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ManifestTreeNode node;
                Node attribute;
                TreePath treePath;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && (attribute = (node = (ManifestTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof Attr) {
                    ManifestPanel.this.goToDeclaration(attribute);
                }
            }

            private void handlePopup(@NotNull MouseEvent e) {
                TreePath treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (treePath == null || e.getSource() == ManifestPanel.this.myDetails) {
                    treePath = ManifestPanel.this.myTree.getSelectionPath();
                }
                if (treePath != null) {
                    ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
                    ManifestPanel.this.myRemoveItem.setEnabled(ManifestPanel.this.canRemove(node.getUserObject()));
                    ManifestPanel.this.myPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)ml);
        this.myDetails.addMouseListener(ml);
    }

    private void registerGotoAction() {
        AnAction goToDeclarationAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ManifestTreeNode node = (ManifestTreeNode)ManifestPanel.this.myTree.getLastSelectedPathComponent();
                if (node != null) {
                    ManifestPanel.this.goToDeclaration(node.getUserObject());
                }
            }
        };
        goToDeclarationAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("GotoDeclaration").getShortcutSet(), (JComponent)this.myTree);
    }

    @NotNull
    private TreeSpeedSearch addSpeedSearch() {
        return new TreeSpeedSearch((JTree)this.myTree);
    }

    public void setManifest(@NotNull MergedManifest manifest, @NotNull VirtualFile selectedManifest) {
        this.myFile = selectedManifest;
        this.myManifest = manifest;
        Document document = this.myManifest.getDocument();
        Element root = document != null ? document.getDocumentElement() : null;
        this.myTree.setModel((TreeModel)(root == null ? null : new DefaultTreeModel(new ManifestTreeNode(root))));
        this.myFiles.clear();
        this.myOtherFiles.clear();
        List<VirtualFile> manifestFiles = this.myManifest.getManifestFiles();
        this.myFiles.add(VfsUtilCore.virtualToIoFile((VirtualFile)selectedManifest));
        HashSet referenced = Sets.newHashSet();
        if (root != null) {
            this.recordLocationReferences(root, referenced);
        }
        if (manifestFiles != null) {
            for (VirtualFile f : manifestFiles) {
                if (f.equals(selectedManifest)) continue;
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)f);
                if (referenced.contains(file)) {
                    this.myFiles.add(file);
                    continue;
                }
                this.myOtherFiles.add(file);
            }
            Collections.sort(this.myFiles, MANIFEST_SORTER);
            Collections.sort(this.myOtherFiles, MANIFEST_SORTER);
        }
        if (root != null) {
            TreeUtil.expandAll((JTree)this.myTree);
        }
        this.updateDetails(null);
    }

    /*
     * WARNING - void declaration
     */
    private void recordLocationReferences(@NotNull Node node, @NotNull Set<File> files) {
        block5: {
            short type;
            block4: {
                type = node.getNodeType();
                if (type != 2) break block4;
                List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
                if (records.isEmpty()) break block5;
                for (Actions.Record record : records) {
                    File location;
                    if (record.getActionType() == Actions.ActionType.INJECTED || (location = record.getActionLocation().getFile().getSourceFile()) == null || files.contains(location)) continue;
                    files.add(location);
                }
                break block5;
            }
            if (type == 1) {
                void var6_10;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1) continue;
                    this.recordLocationReferences(child, files);
                }
                NamedNodeMap attributes = node.getAttributes();
                boolean bl = false;
                int n = attributes.getLength();
                while (var6_10 < n) {
                    this.recordLocationReferences(attributes.item((int)var6_10), files);
                    ++var6_10;
                }
            }
        }
    }

    @Override
    public void valueChanged(@Nullable TreeSelectionEvent e) {
        if (e != null && e.isAddedPath()) {
            TreePath treePath = e.getPath();
            ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            this.updateDetails(node);
        } else {
            this.updateDetails(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateDetails(@Nullable ManifestTreeNode node) {
        HtmlBuilder sb = new HtmlBuilder();
        Font font = UIUtil.getLabelFont();
        sb.addHtml("<html><body style=\"font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt;\">");
        sb.beginUnderline().beginBold();
        sb.add("Manifest Sources");
        sb.endBold().endUnderline().newline();
        sb.addHtml("<table border=\"0\">");
        String borderColor = ColorUtil.toHex((Color)JBColor.GRAY);
        for (File file : this.myFiles) {
            Color color = this.getFileColor(file);
            sb.addHtml("<tr><td width=\"24\" height=\"24\" style=\"background-color:#");
            sb.addHtml(ColorUtil.toHex((Color)color));
            sb.addHtml("; border: 1px solid #");
            sb.addHtml(borderColor);
            sb.addHtml(";\">");
            sb.addHtml("</td><td>");
            this.describePosition(sb, this.myFacet, new SourceFilePosition(file, SourcePosition.UNKNOWN));
            sb.addHtml("</td></tr>");
        }
        sb.addHtml("</table>");
        sb.newline();
        if (!this.myOtherFiles.isEmpty()) {
            sb.beginUnderline().beginBold();
            sb.add("Other Manifest Files");
            sb.endBold().endUnderline().newline();
            sb.add("(Included in merge, but did not contribute any elements)").newline();
            boolean first = true;
            for (File file : this.myOtherFiles) {
                if (first) {
                    first = false;
                } else {
                    sb.add(", ");
                }
                this.describePosition(sb, this.myFacet, new SourceFilePosition(file, SourcePosition.UNKNOWN));
            }
            sb.newline().newline();
        }
        if (!this.myManifest.getLoggingRecords().isEmpty()) {
            for (MergingReport.Record record : this.myManifest.getLoggingRecords()) {
                if (record.getSeverity() != MergingReport.Record.Severity.ERROR) continue;
                node = null;
                break;
            }
        }
        if (node != null) {
            List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node.getUserObject());
            sb.beginUnderline().beginBold();
            sb.add("Merging Log");
            sb.endBold().endUnderline().newline();
            if (records.isEmpty()) {
                sb.add("No records found. (This is a bug in the manifest merger.)");
            }
            Object var6_12 = null;
            for (Actions.Record record : records) {
                void var6_13;
                SourceFilePosition location = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
                if (location.equals((Object)var6_13)) continue;
                SourceFilePosition sourceFilePosition = location;
                Actions.ActionType actionType = record.getActionType();
                if (actionType == Actions.ActionType.INJECTED) {
                    sb.add("Value provided by Gradle");
                    sb.newline();
                    continue;
                }
                sb.add(StringUtil.capitalize((String)String.valueOf(actionType).toLowerCase(Locale.US)));
                sb.add(" from the ");
                sb.addHtml(this.getHtml(this.myFacet, location));
                String reason = record.getReason();
                if (reason != null) {
                    sb.add("; reason: ");
                    sb.add(reason);
                }
                sb.newline();
            }
        } else if (!this.myManifest.getLoggingRecords().isEmpty()) {
            sb.add("Merging Errors:").newline();
            for (MergingReport.Record record : this.myManifest.getLoggingRecords()) {
                sb.addHtml(ManifestPanel.getHtml(record.getSeverity()));
                sb.add(" ");
                try {
                    sb.addHtml(ManifestPanel.getErrorHtml(this.myFacet, record.getMessage(), record.getSourceLocation(), this.myHtmlLinkManager, LocalFileSystem.getInstance().findFileByIoFile(this.myFiles.get(0))));
                }
                catch (Exception exception) {
                    Logger.getInstance(ManifestPanel.class).error("error getting error html", (Throwable)exception);
                    sb.add(record.getMessage());
                }
                sb.add(" ");
                sb.addHtml(this.getHtml(this.myFacet, record.getSourceLocation()));
                sb.newline();
            }
        }
        sb.closeHtmlBody();
        this.myDetails.setText(sb.getHtml());
        this.myDetails.setCaretPosition(0);
    }

    @NotNull
    private Color getNodeColor(@NotNull Node item) {
        File file;
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, item);
        if (!records.isEmpty() && (file = ManifestUtils.getActionLocation(this.myFacet.getModule(), records.get(0)).getFile().getSourceFile()) != null) {
            return this.getFileColor(file);
        }
        return this.myBackgroundColor;
    }

    @NotNull
    private Color getFileColor(@NotNull File file) {
        int index;
        if (!this.myFiles.contains(file)) {
            this.myFiles.add(file);
        }
        if ((index = this.myFiles.indexOf(file)) == 0) {
            return this.myBackgroundColor;
        }
        return AnnotationColors.BG_COLORS[(index - 1) * 3 % AnnotationColors.BG_COLORS.length];
    }

    private boolean canRemove(@NotNull Node node) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
        if (records.isEmpty()) {
            return false;
        }
        File mainManifest = VfsUtilCore.virtualToIoFile((VirtualFile)ManifestUtils.getMainManifest(this.myFacet).getVirtualFile());
        for (Actions.Record record : records) {
            if (!FileUtil.filesEqual((File)ManifestUtils.getActionLocation(this.myFacet.getModule(), record).getFile().getSourceFile(), (File)mainManifest)) continue;
            return false;
        }
        return true;
    }

    private void goToDeclaration(Node element) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, element);
        for (Actions.Record record : records) {
            File ioFile;
            SourceFilePosition sourceFilePosition = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
            SourceFile sourceFile = sourceFilePosition.getFile();
            if (SourceFile.UNKNOWN.equals((Object)sourceFile) || (ioFile = sourceFile.getSourceFile()) == null) continue;
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            assert (file != null);
            int line = -1;
            int column = 0;
            SourcePosition sourcePosition = sourceFilePosition.getPosition();
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                line = sourcePosition.getStartLine();
                column = sourcePosition.getStartColumn();
            }
            Project project = this.myFacet.getModule().getProject();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, line, column);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            break;
        }
    }

    @NotNull
    static String getErrorHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        HtmlBuilder sb = new HtmlBuilder();
        int index = message.indexOf(SUGGESTION_MARKER);
        if (index >= 0) {
            String action = message.substring(index += SUGGESTION_MARKER.length(), message.indexOf(32, index));
            sb.add(message.substring(0, index));
            message = message.substring(index);
            if ("add".equals(action)) {
                sb.addHtml(ManifestPanel.getErrorAddHtml(facet, message, position, htmlLinkManager, currentlyOpenFile));
            } else if ("use".equals(action)) {
                sb.addHtml(ManifestPanel.getErrorUseHtml(facet, message, position, htmlLinkManager, currentlyOpenFile));
            } else if ("remove".equals(action)) {
                sb.addHtml(ManifestPanel.getErrorRemoveHtml(facet, message, position, htmlLinkManager, currentlyOpenFile));
            }
        } else {
            sb.add(message);
        }
        return sb.getHtml();
    }

    @NotNull
    private static String getErrorAddHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        HtmlBuilder sb = new HtmlBuilder();
        Matcher matcher = ADD_SUGGESTION_FORMAT.matcher(message);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unexpected add suggestion format " + message);
        }
        final String attributeName = matcher.group(1);
        final String attributeValue = matcher.group(2);
        String tagName = matcher.group(3);
        int line = Integer.parseInt(matcher.group(4));
        int col = Integer.parseInt(matcher.group(5));
        final XmlFile mainManifest = ManifestUtils.getMainManifest(facet);
        Element element = ManifestPanel.getElementAt(mainManifest, line, col);
        if (element != null && tagName.equals(element.getTagName())) {
            final Element xmlTag = element;
            sb.addLink(message, htmlLinkManager.createRunnableLink(new Runnable(){

                @Override
                public void run() {
                    ManifestPanel.addToolsAttribute(mainManifest, xmlTag, attributeName, attributeValue);
                }
            }));
        } else {
            Logger.getInstance(ManifestPanel.class).warn("can not find " + tagName + " tag " + element);
            sb.add(message);
        }
        return sb.getHtml();
    }

    @Nullable
    private static Element getElementAt(XmlFile mainManifest, int line, int col) {
        Element element = null;
        try {
            Document document = PositionXmlParser.parse((String)mainManifest.getText());
            for (Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)line, (int)col); node != null; node = node.getParentNode()) {
                if (!(node instanceof Element)) continue;
                element = (Element)node;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element;
    }

    @NotNull
    private static String getErrorUseHtml(@NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        HtmlBuilder sb = new HtmlBuilder();
        int eq = message.indexOf(61);
        if (eq < 0) {
            throw new IllegalArgumentException("unexpected use suggestion format " + message);
        }
        int end = message.indexOf(34, eq + 2);
        if (end < 0 || message.charAt(eq + 1) != '\"') {
            throw new IllegalArgumentException("unexpected use suggestion format " + message);
        }
        final String suggestion = message.substring(message.indexOf(32) + 1, end + 1);
        if (!SourcePosition.UNKNOWN.equals((Object)position.getPosition())) {
            final XmlFile mainManifest = ManifestUtils.getMainManifest(facet);
            final Element element = ManifestPanel.getElementAt(mainManifest, position.getPosition().getStartLine(), position.getPosition().getStartColumn());
            if (element != null && "uses-sdk".equals(element.getTagName())) {
                sb.addLink(message.substring(0, end + 1), htmlLinkManager.createRunnableLink(new Runnable(){

                    @Override
                    public void run() {
                        int eq = suggestion.indexOf(61);
                        String attributeName = suggestion.substring(suggestion.indexOf(58) + 1, eq);
                        String attributeValue = suggestion.substring(eq + 2, suggestion.length() - 1);
                        ManifestPanel.addToolsAttribute(mainManifest, element, attributeName, attributeValue);
                    }
                }));
                sb.add(message.substring(end + 1));
            } else {
                Logger.getInstance(ManifestPanel.class).warn("Can not find uses-sdk tag " + element);
                sb.add(message);
            }
        } else {
            sb.add(message);
        }
        sb.newlineIfNecessary().newline();
        return sb.getHtml();
    }

    @NotNull
    private static String getErrorRemoveHtml(final @NotNull AndroidFacet facet, @NotNull String message, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, final @Nullable VirtualFile currentlyOpenFile) {
        int end;
        HtmlBuilder sb = new HtmlBuilder();
        int start = message.indexOf(123);
        String declaration = message.substring(start + 1, end = message.indexOf(125, start + 1)).trim();
        if (!declaration.startsWith("applicationId")) {
            throw new IllegalArgumentException("unexpected remove suggestion format " + message);
        }
        final GradleBuildFile buildFile = GradleBuildFile.get(facet.getModule());
        Runnable link = null;
        if (buildFile != null) {
            final String applicationId = declaration.substring(declaration.indexOf(34) + 1, declaration.lastIndexOf(34));
            File manifestOverlayFile = position.getFile().getSourceFile();
            assert (manifestOverlayFile != null);
            VirtualFile manifestOverlayVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(manifestOverlayFile);
            assert (manifestOverlayVirtualFile != null);
            IdeaSourceProvider sourceProvider = ManifestUtils.findManifestSourceProvider(facet, manifestOverlayVirtualFile);
            assert (sourceProvider != null);
            final String name = sourceProvider.getName();
            AndroidGradleModel androidGradleModel = AndroidGradleModel.get(facet.getModule());
            assert (androidGradleModel != null);
            final XmlFile manifestOverlayPsiFile = (XmlFile)PsiManager.getInstance((Project)facet.getModule().getProject()).findFile(manifestOverlayVirtualFile);
            assert (manifestOverlayPsiFile != null);
            if (androidGradleModel.getBuildTypeNames().contains(name)) {
                final String packageName = MergedManifest.get(facet).getPackage();
                assert (packageName != null);
                if (applicationId.startsWith(packageName)) {
                    link = new Runnable(){

                        @Override
                        public void run() {
                            new WriteCommandAction.Simple(facet.getModule().getProject(), "Apply manifest suggestion", new PsiFile[]{buildFile.getPsiFile(), manifestOverlayPsiFile}){

                                protected void run() throws Throwable {
                                    NamedObject buildType;
                                    if (currentlyOpenFile != null) {
                                        CommandProcessor.getInstance().addAffectedFiles(facet.getModule().getProject(), new VirtualFile[]{currentlyOpenFile});
                                    }
                                    ManifestPanel.removePackageAttribute(manifestOverlayPsiFile);
                                    String applicationIdSuffix = applicationId.substring(packageName.length());
                                    ArrayList<NamedObject> buildTypes = (ArrayList<NamedObject>)buildFile.getValue(BuildFileKey.BUILD_TYPES);
                                    if (buildTypes == null) {
                                        buildTypes = new ArrayList<NamedObject>();
                                    }
                                    if ((buildType = ManifestPanel.find(buildTypes, name)) == null) {
                                        buildType = new NamedObject(name);
                                        buildTypes.add(buildType);
                                    }
                                    buildType.setValue(BuildFileKey.APPLICATION_ID_SUFFIX, applicationIdSuffix);
                                    buildFile.setValue(BuildFileKey.BUILD_TYPES, buildTypes);
                                    GradleProjectImporter.getInstance().requestProjectSync(facet.getModule().getProject(), null);
                                }
                            }.execute();
                        }
                    };
                }
            } else if (androidGradleModel.getProductFlavorNames().contains(name)) {
                link = new Runnable(){

                    @Override
                    public void run() {
                        new WriteCommandAction.Simple(facet.getModule().getProject(), "Apply manifest suggestion", new PsiFile[]{buildFile.getPsiFile(), manifestOverlayPsiFile}){

                            protected void run() throws Throwable {
                                if (currentlyOpenFile != null) {
                                    CommandProcessor.getInstance().addAffectedFiles(facet.getModule().getProject(), new VirtualFile[]{currentlyOpenFile});
                                }
                                ManifestPanel.removePackageAttribute(manifestOverlayPsiFile);
                                List flavors = (List)buildFile.getValue(BuildFileKey.FLAVORS);
                                assert (flavors != null);
                                NamedObject flavor = ManifestPanel.find(flavors, name);
                                assert (flavor != null);
                                flavor.setValue(BuildFileKey.APPLICATION_ID, applicationId);
                                buildFile.setValue(BuildFileKey.FLAVORS, flavors);
                                GradleProjectImporter.getInstance().requestProjectSync(facet.getModule().getProject(), null);
                            }
                        }.execute();
                    }
                };
            }
        }
        if (link != null) {
            sb.addLink(message.substring(0, end + 1), htmlLinkManager.createRunnableLink(link));
            sb.add(message.substring(end + 1));
        } else {
            sb.add(message);
        }
        return sb.getHtml();
    }

    private static void removePackageAttribute(XmlFile manifestFile) {
        XmlTag tag = manifestFile.getRootTag();
        assert (tag != null);
        tag.setAttribute("package", null);
    }

    @Nullable(value="item not found")
    static NamedObject find(@NotNull List<NamedObject> items, @NotNull String name) {
        for (NamedObject item : items) {
            if (!name.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    static void addToolsAttribute(final @NotNull XmlFile file, final @NotNull Element element, final @NotNull String attributeName, final @NotNull String attributeValue) {
        Project project = file.getProject();
        new WriteCommandAction.Simple(project, "Apply manifest suggestion", new PsiFile[]{file}){

            protected void run() throws Throwable {
                ManifestUtils.addToolsAttribute(file, element, attributeName, attributeValue);
            }
        }.execute();
    }

    @NotNull
    static String getHtml(@NotNull MergingReport.Record.Severity severity) {
        String severityString = StringUtil.capitalize((String)severity.toString().toLowerCase(Locale.US));
        if (severity == MergingReport.Record.Severity.ERROR) {
            return new HtmlBuilder().addHtml("<font color=\"#" + ColorUtil.toHex((Color)JBColor.RED) + "\">").addBold(severityString).addHtml("</font>:").getHtml();
        }
        return severityString;
    }

    @NotNull
    String getHtml(@NotNull AndroidFacet facet, @NotNull SourceFilePosition sourceFilePosition) {
        HtmlBuilder sb = new HtmlBuilder();
        this.describePosition(sb, facet, sourceFilePosition);
        return sb.getHtml();
    }

    private void describePosition(@NotNull HtmlBuilder sb, @NotNull AndroidFacet facet, @NotNull SourceFilePosition sourceFilePosition) {
        SourceFile sourceFile = sourceFilePosition.getFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        File file = sourceFile.getSourceFile();
        AndroidLibrary library = null;
        if (file != null) {
            File manifestFile;
            AndroidFacet libraryFacet;
            String source = null;
            Module libraryModule = null;
            Module[] modules = ModuleManager.getInstance((Project)facet.getModule().getProject()).getModules();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile != null) {
                IdeaSourceProvider provider;
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)facet.getModule().getProject());
                if (module != null) {
                    AndroidGradleModel androidModel;
                    if (modules.length >= 2) {
                        source = module.getName();
                    }
                    if (file.getPath().contains("exploded-aar") && (androidModel = AndroidGradleModel.get(module)) != null && (library = GradleUtil.findLibrary(file.getParentFile(), androidModel.getSelectedVariant(), androidModel.getModelVersion())) != null) {
                        if (library.getProject() != null) {
                            libraryModule = GradleUtil.findModuleByGradlePath(facet.getModule().getProject(), library.getProject());
                            if (libraryModule != null) {
                                module = libraryModule;
                                source = module.getName();
                            } else {
                                source = library.getProject();
                                source = StringUtil.trimStart((String)source, (String)":");
                            }
                        } else {
                            MavenCoordinates coordinates = library.getResolvedCoordinates();
                            source = coordinates.getArtifactId() + ":" + coordinates.getVersion();
                        }
                    }
                }
                if ((provider = ManifestUtils.findManifestSourceProvider(facet, vFile)) != null) {
                    String providerName = provider.getName();
                    source = source == null ? providerName : source + " " + providerName;
                }
            }
            if (source == null) {
                source = file.getName();
                if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                    source = source + ":" + String.valueOf(sourcePosition);
                }
            }
            sb.addHtml("<a href=\"");
            boolean redirected = false;
            if (libraryModule != null && (libraryFacet = AndroidFacet.getInstance(libraryModule)) != null && (manifestFile = libraryFacet.getMainSourceProvider().getManifestFile()).exists()) {
                sb.add(manifestFile.toURI().toString());
                redirected = true;
                sourcePosition = SourcePosition.UNKNOWN;
            }
            if (!redirected) {
                sb.add(file.toURI().toString());
                if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                    sb.add(":");
                    sb.add(String.valueOf(sourcePosition.getStartLine()));
                    sb.add(":");
                    sb.add(String.valueOf(sourcePosition.getStartColumn()));
                }
            }
            sb.addHtml("\">");
            sb.add(source);
            sb.addHtml("</a>");
            sb.add(" manifest");
            if (FileUtil.filesEqual((File)file, (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile))) {
                sb.add(" (this file)");
            }
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(", line ");
                sb.add(Integer.toString(sourcePosition.getStartLine()));
            }
        }
    }

    @NotNull
    public static Color harder(@NotNull Color color) {
        if (color.getBlue() == color.getRed() && color.getRed() == color.getGreen()) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], 1.0f, hsb[2]);
    }

    private class FileColorTree
    extends Tree {
        public FileColorTree() {
            this.setFont(ManifestPanel.this.myDefaultFont);
            this.setBackground(ManifestPanel.this.myBackgroundColor);
        }

        public boolean isFileColorsEnabled() {
            if (this.isOpaque()) {
                this.setOpaque(false);
            }
            return true;
        }

        @Nullable
        public Color getFileColorFor(Object object) {
            return ManifestPanel.this.getNodeColor((Node)object);
        }
    }

    private class SyntaxHighlightingCellRenderer
    extends ColoredTreeCellRenderer {
        private final SimpleTextAttributes myTagNameAttributes;
        private final SimpleTextAttributes myNameAttributes;
        private final SimpleTextAttributes myValueAttributes;
        private final SimpleTextAttributes myPrefixAttributes;

        public SyntaxHighlightingCellRenderer() {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color tagNameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_TAG_NAME).getForegroundColor();
            Color nameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_NAME).getForegroundColor();
            Color valueColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_VALUE).getForegroundColor();
            Color prefixColor = globalScheme.getAttributes(XmlHighlighterColors.XML_NS_PREFIX).getForegroundColor();
            this.myTagNameAttributes = new SimpleTextAttributes(1, tagNameColor);
            this.myNameAttributes = new SimpleTextAttributes(0, nameColor);
            this.myValueAttributes = new SimpleTextAttributes(0, valueColor);
            this.myPrefixAttributes = new SimpleTextAttributes(0, prefixColor);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof ManifestTreeNode) {
                ManifestTreeNode node = (ManifestTreeNode)value;
                if (UIUtil.isUnderGTKLookAndFeel()) {
                    this.setBackground(ColorUtil.withAlpha((Color)ManifestPanel.harder(ManifestPanel.this.getNodeColor(node.getUserObject())), (double)0.2));
                    this.setOpaque(true);
                }
                this.setIcon(null);
                if (node.getUserObject() instanceof Element) {
                    Element element = (Element)node.getUserObject();
                    this.append("<");
                    this.append(element.getTagName(), this.myTagNameAttributes);
                    if (!expanded) {
                        this.append(" ... " + this.getCloseTag(node));
                    }
                }
                if (node.getUserObject() instanceof Attr) {
                    Attr attr = (Attr)node.getUserObject();
                    ManifestTreeNode parent = node.getParent();
                    assert (parent != null);
                    if (attr.getPrefix() != null) {
                        this.append(attr.getPrefix(), this.myPrefixAttributes);
                        this.append(":");
                        this.append(attr.getLocalName(), this.myNameAttributes);
                    } else {
                        this.append(attr.getName(), this.myNameAttributes);
                    }
                    this.append("=\"");
                    this.append(attr.getValue(), this.myValueAttributes);
                    this.append("\"");
                    if (parent.lastAttribute() == node) {
                        this.append(" " + this.getCloseTag(node));
                    }
                }
            }
        }

        private String getCloseTag(ManifestTreeNode node) {
            return node.hasElementChildren() ? ">" : "/>";
        }
    }

    static class ManifestTreeNode
    extends DefaultMutableTreeNode {
        public ManifestTreeNode(@NotNull Node obj) {
            super(obj);
        }

        @Override
        @NotNull
        public Node getUserObject() {
            return (Node)super.getUserObject();
        }

        @Override
        public int getChildCount() {
            Node obj = this.getUserObject();
            if (obj instanceof Element) {
                Element element = (Element)obj;
                NamedNodeMap attributes = element.getAttributes();
                int count = attributes.getLength();
                NodeList childNodes = element.getChildNodes();
                int n = childNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1) continue;
                    ++count;
                }
                return count;
            }
            return 0;
        }

        @Override
        @NotNull
        public ManifestTreeNode getChildAt(int index) {
            Node obj = this.getUserObject();
            if (this.children == null && obj instanceof Element) {
                Element element = (Element)obj;
                NamedNodeMap attributes = element.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.add(new ManifestTreeNode(attributes.item(i)));
                }
                NodeList childNodes = element.getChildNodes();
                int n2 = childNodes.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1) continue;
                    this.add(new ManifestTreeNode(child));
                }
            }
            return (ManifestTreeNode)super.getChildAt(index);
        }

        @Override
        public void add(@NotNull MutableTreeNode newChild) {
            this.insert(newChild, this.children == null ? 0 : this.children.size());
        }

        @Override
        @NotNull
        public String toString() {
            Node obj = this.getUserObject();
            if (obj instanceof Attr) {
                Attr xmlAttribute = (Attr)obj;
                return xmlAttribute.getName() + " = " + xmlAttribute.getValue();
            }
            if (obj instanceof Element) {
                Element xmlTag = (Element)obj;
                return xmlTag.getTagName();
            }
            return obj.toString();
        }

        @Override
        @Nullable
        public ManifestTreeNode getParent() {
            return (ManifestTreeNode)super.getParent();
        }

        @NotNull
        public ManifestTreeNode lastAttribute() {
            Node xmlTag = this.getUserObject();
            return this.getChildAt(xmlTag.getAttributes().getLength() - 1);
        }

        public boolean hasElementChildren() {
            Node node = this.getUserObject();
            if (node instanceof Attr) {
                ManifestTreeNode parent = this.getParent();
                assert (parent != null);
                return parent.hasElementChildren();
            }
            return node.getChildNodes().getLength() > 0;
        }
    }
}

