/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.jdi;

import com.android.tools.idea.editors.hprof.jdi.ObjectReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.ValueImpl;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    @Nullable
    private Object[] myCachedValues;

    public ArrayReferenceImpl(@NotNull Field field, @NotNull Instance instance) {
        super(field, instance);
    }

    @Override
    public int length() {
        return this.getCachedValues().length;
    }

    @Override
    public Value getValue(int index) {
        return new ValueImpl(this.myField, this.getCachedValues()[index]);
    }

    @Override
    public List<Value> getValues() {
        return this.getValues(0, this.getCachedValues().length);
    }

    @Override
    public void setValues(List<? extends Value> values) throws InvalidTypeException, ClassNotLoadedException {
    }

    @Override
    public List<Value> getValues(int index, int length) {
        Object[] rawValues = this.getCachedValues();
        ArrayList<Value> values = new ArrayList<Value>(rawValues.length - index);
        for (int i = index; i < rawValues.length; ++i) {
            values.add(new ValueImpl(this.myField, rawValues[i]));
        }
        return values;
    }

    @Override
    public void setValue(int index, Value value) throws InvalidTypeException, ClassNotLoadedException {
    }

    @Override
    public void setValues(int index, List<? extends Value> values, int srcIndex, int length) throws InvalidTypeException, ClassNotLoadedException {
    }

    @NotNull
    public ArrayInstance getArrayInstance() {
        return (ArrayInstance)this.getInstance();
    }

    private Object[] getCachedValues() {
        if (this.myCachedValues == null) {
            this.myCachedValues = this.getArrayInstance().getValues();
        }
        return this.myCachedValues;
    }
}

