/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview.model;

import com.android.tools.idea.editors.hierarchyview.model.DisplayInfo;
import com.android.tools.idea.editors.hierarchyview.model.ViewProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewNode
implements TreeNode {
    @NotNull
    public final String name;
    public final Map<String, ViewProperty> namedProperties = Maps.newHashMap();
    public final List<ViewProperty> properties = Lists.newArrayList();
    public final List<ViewNode> children = Lists.newArrayList();
    @Nullable
    public final ViewNode parent;
    public final int index;
    @NotNull
    public final String hashCode;
    @NotNull
    public final String id;
    @NotNull
    public final DisplayInfo displayInfo;
    @NotNull
    public final Rectangle previewBox = new Rectangle();
    private boolean myParentVisible;
    private boolean myNodeDrawn;
    private ForcedState myForcedState = ForcedState.NONE;

    public ViewNode(@Nullable ViewNode parent, @NotNull String data) {
        int delimIndex;
        this.parent = parent;
        int n = this.index = this.parent == null ? 0 : this.parent.children.size();
        if (this.parent != null) {
            this.parent.children.add(this);
        }
        if ((delimIndex = data.indexOf(64)) < 0) {
            throw new IllegalArgumentException("Invalid format for ViewNode, missing @: " + data);
        }
        this.name = data.substring(0, delimIndex);
        data = data.substring(delimIndex + 1);
        delimIndex = data.indexOf(32);
        this.hashCode = data.substring(0, delimIndex);
        if (data.length() > delimIndex + 1) {
            this.loadProperties(data.substring(delimIndex + 1).trim());
            this.id = this.getProperty("mID", "id").getValue();
        } else {
            this.id = "unknown";
        }
        this.displayInfo = new DisplayInfo(this);
    }

    private void loadProperties(@NotNull String data) {
        boolean stop;
        int start = 0;
        do {
            int index = data.indexOf(61, start);
            ViewProperty property = new ViewProperty(data.substring(start, index));
            int index2 = data.indexOf(44, index + 1);
            int length = Integer.parseInt(data.substring(index + 1, index2));
            start = index2 + 1 + length;
            property.setValue(data.substring(index2 + 1, index2 + 1 + length));
            this.properties.add(property);
            this.namedProperties.put(property.fullName, property);
            boolean bl = stop = start >= data.length();
            if (stop) continue;
            ++start;
        } while (!stop);
        Collections.sort(this.properties);
    }

    @Nullable
    public ViewProperty getProperty(String name, String ... altNames) {
        ViewProperty property = this.namedProperties.get(name);
        for (int i = 0; property == null && i < altNames.length; ++i) {
            property = this.namedProperties.get(altNames[i]);
        }
        return property;
    }

    public void updateNodeDrawn() {
        this.updateNodeDrawn(this.myParentVisible);
    }

    private void updateNodeDrawn(boolean parentVisible) {
        this.myParentVisible = parentVisible;
        if (this.myForcedState == ForcedState.NONE) {
            this.myNodeDrawn = !this.displayInfo.willNotDraw && parentVisible && this.displayInfo.isVisible;
            parentVisible &= this.displayInfo.isVisible;
        } else {
            parentVisible = this.myNodeDrawn = this.myForcedState == ForcedState.VISIBLE && parentVisible;
        }
        for (ViewNode child : this.children) {
            child.updateNodeDrawn(parentVisible);
            this.myNodeDrawn |= child.myNodeDrawn && child.displayInfo.isVisible;
        }
    }

    public boolean isDrawn() {
        return this.myNodeDrawn;
    }

    public boolean isParentVisible() {
        return this.myParentVisible;
    }

    public String toString() {
        return this.name + "@" + this.hashCode;
    }

    @Override
    public ViewNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ViewNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public ForcedState getForcedState() {
        return this.myForcedState;
    }

    public void setForcedState(ForcedState forcedState) {
        this.myForcedState = forcedState;
    }

    public static ViewNode parseFlatString(@NotNull byte[] bytes) {
        ViewNode root = null;
        ViewNode lastNode = null;
        int lastWhitespaceCount = Integer.MIN_VALUE;
        Stack<ViewNode> stack = new Stack<ViewNode>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charsets.UTF_8));
        try {
            String line;
            while ((line = in.readLine()) != null && !"DONE.".equalsIgnoreCase(line)) {
                int whitespaceCount = 0;
                while (line.charAt(whitespaceCount) == ' ') {
                    ++whitespaceCount;
                }
                if (lastWhitespaceCount < whitespaceCount) {
                    stack.push(lastNode);
                } else if (!stack.isEmpty()) {
                    int count = lastWhitespaceCount - whitespaceCount;
                    for (int i = 0; i < count; ++i) {
                        stack.pop();
                    }
                }
                lastWhitespaceCount = whitespaceCount;
                ViewNode parent = null;
                if (!stack.isEmpty()) {
                    parent = (ViewNode)stack.peek();
                }
                lastNode = new ViewNode(parent, line.trim());
                if (root != null) continue;
                root = lastNode;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (root != null) {
            super.updateNodeDrawn(true);
        }
        return root;
    }

    public static enum ForcedState {
        NONE,
        VISIBLE,
        INVISIBLE;

    }
}

