/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview.model;

import com.android.tools.idea.editors.hierarchyview.model.ViewNode;
import com.android.tools.idea.editors.hierarchyview.model.ViewProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayInfo {
    public final int left;
    public final int top;
    public final int width;
    public final int height;
    public final int scrollX;
    public final int scrollY;
    public final boolean willNotDraw;
    public final boolean clipChildren;
    public final float translateX;
    public final float translateY;
    public final float scaleX;
    public final float scaleY;
    @Nullable
    public final String contentDesc;
    public final boolean isVisible;

    DisplayInfo(@NotNull ViewNode node) {
        String contentDescription;
        this.left = this.getInt(node.getProperty("mLeft", "layout:mLeft"), 0);
        this.top = this.getInt(node.getProperty("mTop", "layout:mTop"), 0);
        this.width = this.getInt(node.getProperty("getWidth()", "layout:getWidth()"), 10);
        this.height = this.getInt(node.getProperty("getHeight()", "layout:getHeight()"), 10);
        this.scrollX = this.getInt(node.getProperty("mScrollX", "scrolling:mScrollX"), 0);
        this.scrollY = this.getInt(node.getProperty("mScrollY", "scrolling:mScrollY"), 0);
        this.willNotDraw = this.getBoolean(node.getProperty("willNotDraw()", "drawing:willNotDraw()"), false);
        this.clipChildren = this.getBoolean(node.getProperty("getClipChildren()", "drawing:getClipChildren()"), true);
        this.translateX = this.getFloat(node.getProperty("getTranslationX", "drawing:getTranslationX()"), 0.0f);
        this.translateY = this.getFloat(node.getProperty("getTranslationY", "drawing:getTranslationY()"), 0.0f);
        this.scaleX = this.getFloat(node.getProperty("getScaleX()", "drawing:getScaleX()"), 1.0f);
        this.scaleY = this.getFloat(node.getProperty("getScaleY()", "drawing:getScaleY()"), 1.0f);
        ViewProperty descProp = node.getProperty("accessibility:getContentDescription()", new String[0]);
        String string = contentDescription = descProp != null && descProp.getValue() != null && !descProp.getValue().equals("null") ? descProp.getValue() : null;
        if (contentDescription == null) {
            descProp = node.getProperty("text:mText", new String[0]);
            contentDescription = descProp != null && descProp.getValue() != null && !descProp.getValue().equals("null") ? descProp.getValue() : null;
        }
        this.contentDesc = contentDescription;
        ViewProperty visibility = node.getProperty("getVisibility()", "misc:getVisibility()");
        this.isVisible = visibility == null || "0".equals(visibility.getValue()) || "VISIBLE".equals(visibility.getValue());
    }

    private boolean getBoolean(@Nullable ViewProperty p, boolean defaultValue) {
        if (p != null) {
            try {
                return Boolean.parseBoolean(p.getValue());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private int getInt(@Nullable ViewProperty p, int defaultValue) {
        if (p != null) {
            try {
                return Integer.parseInt(p.getValue());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private float getFloat(@Nullable ViewProperty p, float defaultValue) {
        if (p != null) {
            try {
                return Float.parseFloat(p.getValue());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

