/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer;

import com.android.tools.idea.editors.gfxtrace.viewer.CameraModel;
import com.android.tools.idea.editors.gfxtrace.viewer.Renderable;
import com.android.tools.idea.editors.gfxtrace.viewer.ShaderSource;
import com.android.tools.idea.editors.gfxtrace.viewer.gl.Shader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class Viewer
implements GLEventListener {
    private static final Logger LOG = Logger.getInstance(Viewer.class);
    private final CameraModel myCamera;
    private Shaders myShaders;
    private Renderable myRenderable;
    private Renderable newRenderable;
    private Shading myShading = Shading.LIT;
    private Winding myWinding = Winding.CCW;
    private Culling myCulling = Culling.OFF;

    public Viewer(CameraModel camera) {
        this.myCamera = camera;
    }

    public void addMouseListeners(Component component) {
        MouseHandler handler = new MouseHandler(component);
        component.addMouseListener(handler);
        component.addMouseMotionListener(handler);
        component.addMouseWheelListener(handler);
    }

    public void setRenderable(Renderable renderable) {
        this.newRenderable = renderable != this.myRenderable ? renderable : null;
    }

    public Shading getShading() {
        return this.myShading;
    }

    public Culling getCulling() {
        return this.myCulling;
    }

    public Winding getWinding() {
        return this.myWinding;
    }

    public void setShading(Shading shading) {
        this.myShading = shading;
    }

    public void setCulling(Culling culling) {
        this.myCulling = culling;
    }

    public void setWinding(Winding winding) {
        this.myWinding = winding;
    }

    public void init(GLAutoDrawable drawable) {
        float[] background = UIUtil.getPanelBackground().getRGBComponents(null);
        GL2ES2 gl = drawable.getGL().getGL2ES2();
        LOG.debug("GL Version:   " + gl.glGetString(7938));
        LOG.debug("GLSL Version: " + gl.glGetString(35724));
        this.myShaders = Shaders.init(gl);
        if (this.myRenderable != null) {
            this.myRenderable.init(gl);
        }
        gl.glEnable(2929);
        gl.glClearColor(background[0], background[1], background[2], background[3]);
        gl.getGL2GL3().glPointSize(4.0f);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2ES2 gl = drawable.getGL().getGL2ES2();
        gl.glViewport(x, y, width, height);
        this.myCamera.updateViewport(width, height);
    }

    public void display(GLAutoDrawable drawable) {
        GL2ES2 gl = drawable.getGL().getGL2ES2();
        gl.glClear(16640);
        if (this.newRenderable != null) {
            if (this.myRenderable != null) {
                this.myRenderable.dispose(gl);
            }
            this.myRenderable = this.newRenderable;
            this.myRenderable.init(gl);
            this.newRenderable = null;
        }
        if (this.myRenderable != null) {
            Renderable.State state = this.myShading.getState(this.myShaders, this.myWinding.invertNormals);
            this.myCulling.apply(gl);
            this.myWinding.apply(gl, state.shader);
            state.transform.setProjection(this.myCamera.getProjection());
            state.transform.setModelView(this.myCamera.getViewTransform());
            this.myRenderable.render(gl, state);
            gl.glDisable(2884);
        }
    }

    public void dispose(GLAutoDrawable drawable) {
        GL2ES2 gl = drawable.getGL().getGL2ES2();
        this.myShaders.delete();
        if (this.myRenderable != null) {
            this.myRenderable.dispose(gl);
        }
    }

    private static class Shaders {
        public final Shader myLitShader;
        public final Shader myFlatShader;
        public final Shader myNormalShader;

        private Shaders(Shader litShader, Shader flatShader, Shader normalShader) {
            this.myLitShader = litShader;
            this.myFlatShader = flatShader;
            this.myNormalShader = normalShader;
        }

        public static Shaders init(GL2ES2 gl) {
            return new Shaders(ShaderSource.loadShader(gl, "lit"), ShaderSource.loadShader(gl, "flat"), ShaderSource.loadShader(gl, "normals"));
        }

        public void delete() {
            this.myLitShader.delete();
            this.myFlatShader.delete();
            this.myNormalShader.delete();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private final Component component;
        private int lastX;
        private int lastY;

        public MouseHandler(Component component) {
            this.component = component;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Viewer.this.myCamera.onZoom((float)e.getWheelRotation() / 6.0f);
            this.component.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastX = e.getX();
            this.lastY = e.getY();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Viewer.this.myCamera.onDrag(x - this.lastX, y - this.lastY);
            this.component.repaint();
            this.lastX = x;
            this.lastY = y;
        }
    }

    public static enum Shading {
        LIT{

            @Override
            public Renderable.State getState(Shaders shaders, boolean invertNormals) {
                Renderable.State state = new Renderable.State(shaders.myLitShader, invertNormals);
                state.shader.bind();
                state.shader.setUniform("uLightDir", new float[]{0.0f, -0.707f, -0.707f, 0.0f, 0.707f, -0.707f, -0.707f, 0.0f, 0.707f, 0.707f, 0.0f, 0.707f});
                state.shader.setUniform("uLightColor", new float[]{0.2f, 0.2f, 0.2f, 0.4f, 0.4f, 0.4f, 0.5f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f});
                state.shader.setUniform("uLightSpecColor", new float[]{0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f});
                state.shader.setUniform("uLightSize", new float[]{0.0f, 0.05f, 0.05f, 0.0f});
                state.shader.setUniform("uDiffuseColor", new float[]{0.37868f, 0.5605f, 0.03703f});
                state.shader.setUniform("uSpecularColor", new float[]{0.3f, 0.3f, 0.3f});
                state.shader.setUniform("uRoughness", Float.valueOf(0.25f));
                return state;
            }
        }
        ,
        FLAT{

            @Override
            public Renderable.State getState(Shaders shaders, boolean invertNormals) {
                Renderable.State state = new Renderable.State(shaders.myFlatShader, false);
                state.shader.bind();
                state.shader.setUniform("uDiffuseColor", new float[]{0.640625f, 0.7734375f, 0.22265625f});
                return state;
            }
        }
        ,
        NORMALS{

            @Override
            public Renderable.State getState(Shaders shaders, boolean invertNormals) {
                Renderable.State state = new Renderable.State(shaders.myNormalShader, invertNormals);
                state.shader.bind();
                return state;
            }
        };


        public abstract Renderable.State getState(Shaders var1, boolean var2);
    }

    public static enum Winding {
        CCW(false){

            @Override
            public void apply(GL2ES2 gl, Shader shader) {
                gl.glFrontFace(2305);
            }
        }
        ,
        CW(true){

            @Override
            public void apply(GL2ES2 gl, Shader shader) {
                gl.glFrontFace(2304);
            }
        };

        public final boolean invertNormals;

        private Winding(boolean invertNormals) {
            this.invertNormals = invertNormals;
        }

        public abstract void apply(GL2ES2 var1, Shader var2);
    }

    public static enum Culling {
        OFF{

            @Override
            public void apply(GL2ES2 gl) {
                gl.glDisable(2884);
            }
        }
        ,
        ON{

            @Override
            public void apply(GL2ES2 gl) {
                gl.glEnable(2884);
            }
        };


        public abstract void apply(GL2ES2 var1);
    }
}

