/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Interface;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class ArrayIndexPath
extends Path {
    private Path myArray;
    private long myIndex;
    private static final Entity ENTITY = new Entity("path", "ArrayIndex", "", "");

    @Override
    public String getSegmentString() {
        return '[' + String.valueOf(this.myIndex) + ']';
    }

    @Override
    public void appendSegmentToPath(StringBuilder builder) {
        builder.append(this.getSegmentString());
    }

    @Override
    public Path getParent() {
        return this.myArray;
    }

    public Path getArray() {
        return this.myArray;
    }

    public ArrayIndexPath setArray(Path v) {
        this.myArray = v;
        return this;
    }

    public long getIndex() {
        return this.myIndex;
    }

    public ArrayIndexPath setIndex(long v) {
        this.myIndex = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("Array", (Type)new Interface("Path")), new Field("Index", (Type)new Primitive("uint64", Method.Uint64))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            return ENTITY;
        }

        @NotNull
        public BinaryObject create() {
            return new ArrayIndexPath();
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            ArrayIndexPath o = (ArrayIndexPath)obj;
            e.object(o.myArray.unwrap());
            e.uint64(o.myIndex);
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            ArrayIndexPath o = (ArrayIndexPath)obj;
            o.myArray = Path.wrap(d.object());
            o.myIndex = d.uint64();
        }
    }
}

