/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service;

import com.android.tools.idea.editors.gfxtrace.service.ContextID;
import com.android.tools.idea.editors.gfxtrace.service.Hierarchy;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import com.google.common.base.Objects;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HierarchyList
implements BinaryObject {
    private Hierarchy[] myHierarchies;
    private static final Entity ENTITY = new Entity("service", "HierarchyList", "", "");

    public Hierarchy get(int index) {
        return this.myHierarchies[index];
    }

    public int count() {
        return this.myHierarchies != null ? this.myHierarchies.length : 0;
    }

    @Nullable
    public Hierarchy findSimilar(@Nullable Hierarchy old) {
        if (this.count() == 0) {
            return null;
        }
        if (old != null) {
            ContextID ctx = old.getContext();
            String name = old.getName();
            Hierarchy firstMatching = null;
            for (Hierarchy hierarchy : this.myHierarchies) {
                if (!hierarchy.getContext().equals((Object)ctx)) continue;
                if (hierarchy.getName().equals(name)) {
                    return hierarchy;
                }
                if (firstMatching != null) continue;
                firstMatching = hierarchy;
            }
            if (firstMatching != null) {
                return firstMatching;
            }
        }
        return this.get(0);
    }

    @Nullable
    public Hierarchy firstWithContext(@NotNull ContextID contextID) {
        if (this.myHierarchies != null) {
            for (Hierarchy hierarchy : this.myHierarchies) {
                if (!Objects.equal((Object)((Object)hierarchy.getContext()), (Object)((Object)contextID))) continue;
                return hierarchy;
            }
        }
        return null;
    }

    public Hierarchy[] getHierarchies() {
        return this.myHierarchies;
    }

    public HierarchyList setHierarchies(Hierarchy[] v) {
        this.myHierarchies = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static /* synthetic */ Hierarchy[] access$102(HierarchyList x0, Hierarchy[] x1) {
        x0.myHierarchies = x1;
        return x1;
    }

    static {
        ENTITY.setFields(new Field[]{new Field("Hierarchies", (Type)new Slice("", (Type)new Struct(Hierarchy.Klass.INSTANCE.entity())))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            return ENTITY;
        }

        @NotNull
        public BinaryObject create() {
            return new HierarchyList();
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            HierarchyList o = (HierarchyList)obj;
            e.uint32((long)o.myHierarchies.length);
            for (int i = 0; i < o.myHierarchies.length; ++i) {
                e.value((BinaryObject)o.myHierarchies[i]);
            }
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            HierarchyList o = (HierarchyList)obj;
            HierarchyList.access$102(o, new Hierarchy[d.uint32()]);
            for (int i = 0; i < o.myHierarchies.length; ++i) {
                ((HierarchyList)o).myHierarchies[i] = new Hierarchy();
                d.value((BinaryObject)o.myHierarchies[i]);
            }
        }
    }
}

