/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.repository.Revision;
import com.intellij.openapi.diagnostic.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Version {
    private static final Logger LOG = Logger.getInstance(Version.class);
    private static final Pattern VERSION_REGEX = Pattern.compile("version (\\d+)(?:\\.(\\d+))?(?::(.+))?(?:\\s|$)");
    public static final Version NULL_VERSION = new Version(0, 0, null);
    public static final Version VERSION_1 = new Version(1, 0, null);
    public static final Version VERSION_2 = new Version(2, 0, null);
    public static final Version VERSION_3 = new Version(3, 0, null);
    public final int major;
    public final int minor;
    public final String build;

    public Version(int major, int minor, String build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public boolean isAtLeast(Version min) {
        return this.major >= min.major && this.minor >= min.minor;
    }

    public boolean isCompatible(Revision rev) {
        return rev.getMajor() == this.major && rev.getMinor() >= this.minor;
    }

    public String getSdkPackagePath() {
        return "extras;android;gapid;" + this.major;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.major).append('.').append(this.minor);
        if (this.build != null) {
            result.append(':').append(this.build);
        }
        return result.toString();
    }

    @NotNull
    public static Version parse(String version) {
        Matcher m = VERSION_REGEX.matcher(version);
        if (!m.find()) {
            return NULL_VERSION;
        }
        String major = m.group(1);
        String minor = m.group(2);
        String build = m.group(3);
        try {
            return new Version(Integer.parseInt(major), minor == null ? 0 : Integer.parseInt(minor), build);
        }
        catch (NumberFormatException e) {
            LOG.warn("Malformed version number: " + version, (Throwable)e);
            return NULL_VERSION;
        }
    }
}

