/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Base64;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class ChildProcess {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ChildProcess.class);
    @NotNull
    private static final Pattern PORT_PATTERN = Pattern.compile("^Bound on port '(\\d+)'$", 0);
    private static final int AUTH_TOKEN_LENGTH = 8;
    private final String myName;
    private Thread myServerThread;
    protected Process myProcess;

    ChildProcess(String name) {
        this.myName = name;
    }

    protected abstract boolean prepare(ProcessBuilder var1);

    protected abstract void onExit(int var1);

    public boolean isRunning() {
        return this.myServerThread != null && this.myServerThread.isAlive();
    }

    public SettableFuture<Integer> start() {
        final ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(GapiPaths.base());
        if (!this.prepare(pb)) {
            return null;
        }
        final SettableFuture portF = SettableFuture.create();
        this.myServerThread = new Thread(){

            @Override
            public void run() {
                ChildProcess.this.runProcess((SettableFuture<Integer>)portF, pb);
            }
        };
        this.myServerThread.start();
        return portF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProcess(final SettableFuture<Integer> portF, ProcessBuilder pb) {
        try {
            LOG.info("Starting " + this.myName + " as " + pb.command());
            this.myProcess = pb.start();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            portF.setException((Throwable)e);
            return;
        }
        OutputHandler stdout = new OutputHandler(this.myProcess.getInputStream(), false){
            private boolean seenPort;
            {
                super(in, warn);
                this.seenPort = false;
            }

            @Override
            protected void processLine(String line) {
                Matcher matcher;
                super.processLine(line);
                if (!this.seenPort && (matcher = PORT_PATTERN.matcher(line)).matches()) {
                    int port = Integer.parseInt(matcher.group(1));
                    this.seenPort = true;
                    portF.set((Object)port);
                    LOG.info("Detected server " + ChildProcess.this.myName + " startup on port " + port);
                }
            }
        };
        OutputHandler stderr = new OutputHandler(this.myProcess.getErrorStream(), true);
        try {
            this.onExit(this.myProcess.waitFor());
            if (!portF.isDone()) {
                portF.setException((Throwable)new Exception(this.myName + " has exited"));
            }
        }
        catch (InterruptedException e) {
            LOG.info("Killing " + this.myName);
            portF.setException((Throwable)e);
            this.myProcess.destroy();
        }
        finally {
            stdout.close();
            stderr.close();
        }
    }

    public void shutdown() {
        LOG.info("Shutting down " + this.myName);
        this.myServerThread.interrupt();
    }

    @NotNull
    protected static String generateAuthToken() {
        SecureRandom rnd = new SecureRandom();
        byte[] bytes = new byte[6];
        rnd.nextBytes(bytes);
        return Base64.encode((byte[])bytes);
    }

    protected class OutputHandler
    extends Thread
    implements Closeable {
        private final BufferedReader reader;
        private final boolean warn;

        public OutputHandler(InputStream in, boolean warn) {
            this.reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
            this.warn = warn;
            this.start();
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.processLine(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void processLine(String line) {
            if (this.warn) {
                LOG.warn(ChildProcess.this.myName + ": " + line);
            } else {
                LOG.info(ChildProcess.this.myName + ": " + line);
            }
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

