/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.actions.ViewTextAction;
import com.android.tools.idea.editors.gfxtrace.controllers.TreeController;
import com.android.tools.idea.editors.gfxtrace.models.GpuState;
import com.android.tools.idea.editors.gfxtrace.renderers.Render;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemorySliceInfo;
import com.android.tools.idea.editors.gfxtrace.service.path.FieldPath;
import com.android.tools.idea.editors.gfxtrace.service.path.MapIndexPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.snippets.CanFollow;
import com.android.tools.idea.editors.gfxtrace.service.snippets.KindredSnippets;
import com.android.tools.idea.editors.gfxtrace.service.snippets.SnippetObject;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Type;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.IntArrayList;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsItem;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateController
extends TreeController
implements GpuState.Listener {
    @NotNull
    private static final Logger LOG = Logger.getInstance(StateController.class);
    @NotNull
    private static final TypedValue ROOT_TYPE = new TypedValue(null, SnippetObject.symbol("state"));
    @NotNull
    private final StateTreeModel myModel = new StateTreeModel(new Node(ROOT_TYPE, null, false));
    @Nullable
    private TreePath myLastSelectedBreadcrumb;

    public static JComponent createUI(@NotNull GfxTraceEditor editor) {
        return new StateController((GfxTraceEditor)editor).myPanel;
    }

    private StateController(@NotNull GfxTraceEditor editor) {
        super(editor, "Select a frame or command");
        this.myEditor.getGpuState().addListener(this);
        this.myScrollPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.setModel(this.myModel);
        MouseAdapter mouseHandler = new MouseAdapter(){
            private JPopupMenu popupMenu = new JPopupMenu();

            @Override
            public void mouseMoved(MouseEvent event) {
                Node node;
                TreePath treePath = StateController.this.getFollowAt(event.getX(), event.getY());
                Path followPath = null;
                if (treePath != null && (followPath = (node = (Node)treePath.getLastPathComponent()).getFollowPath()) == null) {
                    node.setFollowPath(Path.EMPTY);
                    final Path path = StateController.this.getPath(treePath);
                    Futures.addCallback(StateController.this.myEditor.getClient().follow(path), (FutureCallback)new FutureCallback<Path>(){

                        public void onSuccess(Path result) {
                            node.setFollowPath(result);
                        }

                        public void onFailure(Throwable t) {
                            LOG.warn("Error: " + t + " for path " + path);
                        }
                    });
                }
                TreeController.hoverHand((Component)((Object)StateController.this.myTree), StateController.this.myEditor.getGpuState().getPath(), followPath);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TreeController.hoverHand((Component)((Object)StateController.this.myTree), StateController.this.myEditor.getGpuState().getPath(), null);
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath treePath = StateController.this.getFollowAt(event.getX(), event.getY());
                if (treePath != null) {
                    Path path = ((Node)treePath.getLastPathComponent()).getFollowPath();
                    if (path != null && path != Path.EMPTY) {
                        GfxTraceUtil.trackEvent("gfxTraceLinkClicked", path.toString(), null);
                        StateController.this.myEditor.activatePath(path, StateController.this);
                    } else {
                        LOG.warn("click, but we don't have a path :(");
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path;
                if (e.isPopupTrigger() && (path = StateController.this.myTree.getPathForLocation(e.getX(), e.getY())) != null) {
                    Node treeNode = (Node)path.getLastPathComponent();
                    if (treeNode.value.type instanceof Primitive && ((Primitive)treeNode.value.type).getMethod() == Method.String) {
                        String title = TreeController.getDisplayTextFor(StateController.this.myEditor.getGpuState().getPath(), StateController.this.getPath(path));
                        ViewTextAction viewText = new ViewTextAction(StateController.this.myEditor.getProject(), title, treeNode.value.value.getObject());
                        this.popupMenu.removeAll();
                        this.popupMenu.add(viewText);
                        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.myTree.addMouseListener(mouseHandler);
        this.myTree.addMouseMotionListener(mouseHandler);
        final BreadcrumbsComponent breadcrumb = new BreadcrumbsComponent();
        breadcrumb.addBreadcrumbsItemListener((BreadcrumbsItemListener)new BreadcrumbsItemListener<PathBreadcrumbsItem>(){

            public void itemSelected(@NotNull PathBreadcrumbsItem item, int modifiers) {
                StateController.this.myLastSelectedBreadcrumb = item.getTreePath();
                StateController.this.myEditor.activatePath(StateController.this.getPath(StateController.this.myLastSelectedBreadcrumb), StateController.this);
            }

            public void itemHovered(@Nullable PathBreadcrumbsItem item) {
                TreeController.hoverHand((Component)breadcrumb, StateController.this.myEditor.getGpuState().getPath(), item == null ? null : StateController.this.getPath(item.getTreePath()));
            }
        });
        this.myPanel.add((Component)breadcrumb, "North");
        this.myTree.addTreeSelectionListener(e -> {
            TreePath path;
            if (e.isAddedPath() && !(path = e.getPath()).equals(this.myLastSelectedBreadcrumb)) {
                TreePath root = new TreePath(this.myTree.getModel().getRoot());
                ArrayList<PathBreadcrumbsItem> breadcrumbs = new ArrayList<PathBreadcrumbsItem>();
                while (path != null && !path.equals(root)) {
                    breadcrumbs.add(new PathBreadcrumbsItem(path));
                    path = path.getParentPath();
                }
                Collections.reverse(breadcrumbs);
                breadcrumb.setItems(breadcrumbs);
                this.myLastSelectedBreadcrumb = null;
            }
        });
    }

    @Nullable(value="nothing to follow at this location")
    private TreePath getFollowAt(int mouseX, int mouseY) {
        TreePath treePath = this.myTree.getPathForLocation(mouseX, mouseY);
        if (treePath == null) {
            return null;
        }
        Node node = (Node)treePath.getLastPathComponent();
        if (node.isLeaf() && !node.canFollow()) {
            return null;
        }
        Rectangle bounds = this.myTree.getPathBounds(treePath);
        assert (bounds != null);
        int tag = Render.getNodeFieldIndex((JTree)((Object)this.myTree), node, mouseX - bounds.x, this.myTree.isExpanded(treePath));
        if (tag == -1) {
            return null;
        }
        if (node.isLeaf() && tag == 0) {
            return treePath;
        }
        Node child = node.getChild(tag);
        return child.canFollow() ? new TreePath(Stream.concat(Arrays.stream(treePath.getPath()), Arrays.stream(new Object[]{child})).toArray()) : null;
    }

    @NotNull
    private Path getPath(@NotNull TreePath treePath) {
        Object[] nodePath;
        Path parent = null;
        for (Object node : nodePath = treePath.getPath()) {
            if (node == nodePath[0]) {
                assert (this.myTree.getModel().getRoot().equals(node));
                assert (ROOT_TYPE.equals(((Node)node).key));
                assert ("state".equals(((Node)node).key.value.getObject()));
                parent = this.myEditor.getGpuState().getPath();
                continue;
            }
            parent = StateController.getPathSegmentFor(parent, (Node)node);
        }
        assert (parent != null);
        return parent;
    }

    @NotNull
    private static Path getPathSegmentFor(@Nullable Path parent, @NotNull Node node) {
        Object obj = node.key.value.getObject();
        if (node.isMapKey) {
            MapIndexPath path = new MapIndexPath();
            path.setKey(obj);
            path.setMap(parent);
            return path;
        }
        if (obj instanceof String) {
            FieldPath path = new FieldPath();
            path.setName((String)obj);
            path.setStruct(parent);
            return path;
        }
        throw new IllegalArgumentException("unknown type: " + obj.getClass().getSimpleName());
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }

    @Override
    public void onStateLoadingStart(GpuState state) {
        this.myLoadingPanel.startLoading();
    }

    @Override
    public void onStateLoadingFailure(GpuState state, ErrDataUnavailable error) {
        this.myLoadingPanel.stopLoading();
        this.myTree.getEmptyText().setText(error.getMessage());
        this.clear();
    }

    @Override
    public void onStateLoadingSuccess(GpuState state) {
        this.myLoadingPanel.stopLoading();
        if (this.getModel() != this.myModel) {
            this.setModel(this.myModel);
        }
        this.myModel.setRoot(StateController.convert(ROOT_TYPE, new TypedValue(null, SnippetObject.root(state.getState(), this.getSnippets(state))), false));
    }

    @Override
    public void onStateSelection(GpuState state, Path path) {
        SnippetObject[] selection = StateController.getStatePath(path);
        Node node = (Node)this.myModel.getRoot();
        TreePath treePath = new TreePath(node);
        for (int i = 0; i < selection.length && !node.isLeaf() && (node = node.findChild(selection[i])) != null; ++i) {
            treePath = treePath.pathByAddingChild(node);
        }
        TreePath expandPath = node == null || node.isLeaf() ? treePath.getParentPath() : treePath;
        this.myTree.expandPath(expandPath);
        this.myTree.setSelectionPath(treePath);
        int row = this.myTree.getRowForPath(expandPath) + (node == null ? 0 : node.getChildCount());
        if (row >= this.myTree.getRowCount()) {
            row = this.myTree.getRowCount() - 1;
        }
        this.myTree.scrollPathToVisible(this.myTree.getPathForRow(row));
        this.myTree.scrollPathToVisible(treePath);
    }

    private static SnippetObject[] getStatePath(Path path) {
        LinkedList result = Lists.newLinkedList();
        while (path != null) {
            if (path instanceof FieldPath) {
                result.add(0, SnippetObject.symbol(((FieldPath)path).getName()));
            } else {
                if (!(path instanceof MapIndexPath)) break;
                result.add(0, SnippetObject.symbol(((MapIndexPath)path).getKey()));
            }
            path = path.getParent();
        }
        return result.toArray(new SnippetObject[result.size()]);
    }

    private KindredSnippets[] getSnippets(GpuState state) {
        return KindredSnippets.fromMetadata(state.getState().klass().entity().getMetadata());
    }

    private static Node convert(TypedValue key, TypedValue value, boolean isMapKey) {
        Node result;
        block4: {
            result = new Node(key, value, isMapKey);
            SnippetObject obj = value.value;
            Object underlying = obj.getObject();
            if (!(underlying instanceof Dynamic) && !(value.type instanceof Map)) break block4;
            if (underlying instanceof Dynamic) {
                Dynamic dynamic = (Dynamic)underlying;
                for (int i = 0; i < dynamic.getFieldCount(); ++i) {
                    Field field = dynamic.getFieldInfo(i);
                    SnippetObject fieldObj = obj.field(dynamic, i);
                    StateController.addChildNode(result, null, SnippetObject.symbol(field.getDeclared()), field.getType(), fieldObj, false);
                }
            } else {
                java.util.Map map = (java.util.Map)underlying;
                Type keyType = ((Map)value.type).getKeyType();
                Type valueType = ((Map)value.type).getValueType();
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    StateController.addChildNode(result, keyType, obj.key(entry), valueType, obj.elem(entry), true);
                }
            }
        }
        return result;
    }

    private static void addChildNode(Node parent, Type keyType, SnippetObject keyValue, Type valueType, SnippetObject valueValue, boolean isMapKey) {
        if (!(valueValue.getObject() instanceof MemorySliceInfo)) {
            parent.addChild(StateController.convert(new TypedValue(keyType, keyValue), new TypedValue(valueType, valueValue), isMapKey));
        }
    }

    @Override
    @NotNull
    protected TreeCellRenderer getRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof Node) {
                    Render.render((Node)value, (SimpleColoredComponent)this, SimpleTextAttributes.REGULAR_ATTRIBUTES, expanded);
                } else assert (false);
            }
        };
    }

    @Override
    @NotNull
    public String[] getColumns(TreePath path) {
        Object object = path.getLastPathComponent();
        if (object instanceof Node) {
            SimpleColoredComponent component;
            Node node = (Node)object;
            String key = "";
            if (node.key.type != null) {
                component = new SimpleColoredComponent();
                Render.render(node.key.value, node.key.type, component, SimpleTextAttributes.REGULAR_ATTRIBUTES, 0);
                key = component.toString();
            } else {
                key = String.valueOf(node.key.value.getObject());
            }
            if (!node.isLeaf() || node.value == null || node.value.value == null || node.value.value.getObject() == null) {
                return new String[]{key};
            }
            component = new SimpleColoredComponent();
            Render.render(node.value.value, node.value.type, component, SimpleTextAttributes.REGULAR_ATTRIBUTES, 0);
            String value = component.toString();
            return new String[]{key, value};
        }
        return new String[]{object.toString()};
    }

    private static class StateTreeModel
    implements TreeModel {
        private final Listeners listeners = new Listeners();
        private Node root;

        public StateTreeModel(Node root) {
            this.root = root;
        }

        public void setRoot(Node state) {
            if (this.root.isLeaf()) {
                this.root = state;
                this.listeners.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
            } else {
                this.root.merge(state, Lists.newArrayList(), this.listeners);
            }
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public int getChildCount(Object parent) {
            return ((Node)parent).getChildCount();
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((Node)parent).getChild(index);
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((Node)node).isLeaf();
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (!(parent instanceof Node) || child == null) {
                return -1;
            }
            return ((Node)parent).getChildIndex(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        private static class Listeners
        extends ArrayList<TreeModelListener>
        implements TreeModelListener {
            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeNodesChanged(e);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeNodesInserted(e);
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeNodesRemoved(e);
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeStructureChanged(e);
                }
            }
        }
    }

    public static class Node {
        public final boolean isMapKey;
        public final TypedValue key;
        public TypedValue value;
        private final List<Node> childrenByIndex = Lists.newArrayList();
        private final HashMap<TypedValue, Node> childrenByKey = Maps.newHashMap();
        @Nullable(value="not made server request yet")
        private Path followPath;

        public Node(TypedValue key, TypedValue value, boolean isMapKey) {
            this.key = key;
            this.value = value;
            this.isMapKey = isMapKey;
        }

        public void addChild(Node node) {
            this.childrenByIndex.add(node);
            this.childrenByKey.put(node.key, node);
        }

        public void merge(Node other, List<Object> path, TreeModelListener listener) {
            Node child2;
            int i;
            IntArrayList changedIndecies = new IntArrayList(Math.max(this.getChildCount(), other.getChildCount()));
            ArrayList changedChildren = Lists.newArrayListWithCapacity((int)Math.max(this.getChildCount(), other.getChildCount()));
            path.add(this);
            this.followPath = null;
            for (i = 0; i < this.childrenByIndex.size(); ++i) {
                child2 = this.childrenByIndex.get(i);
                if (other.childrenByKey.containsKey(child2.key)) continue;
                changedIndecies.add(i + changedIndecies.size());
                changedChildren.add(child2);
                this.childrenByIndex.remove(i);
                this.childrenByKey.remove(child2.key);
                --i;
            }
            if (!changedIndecies.isEmpty()) {
                listener.treeNodesRemoved(new TreeModelEvent((Object)this, path.toArray(), changedIndecies.toArray(), changedChildren.toArray()));
                changedIndecies.clear();
                changedChildren.clear();
            }
            for (i = 0; i < other.childrenByIndex.size(); ++i) {
                child2 = other.childrenByIndex.get(i);
                if (this.childrenByKey.containsKey(child2.key)) continue;
                changedIndecies.add(this.childrenByIndex.size());
                changedChildren.add(child2);
                this.addChild(child2);
            }
            if (!changedIndecies.isEmpty()) {
                listener.treeNodesInserted(new TreeModelEvent((Object)this, path.toArray(), changedIndecies.toArray(), changedChildren.toArray()));
                changedIndecies.clear();
                changedChildren.clear();
            }
            for (Node child2 : this.childrenByIndex) {
                child2.merge(other.childrenByKey.get(child2.key), path, listener);
            }
            if (this.isLeaf() && !Objects.equal((Object)this.value, (Object)other.value)) {
                this.value = other.value;
                listener.treeNodesChanged(new TreeModelEvent((Object)this, path.toArray()));
            } else {
                this.value = other.value;
            }
            path.remove(path.size() - 1);
        }

        public int getChildCount() {
            return this.childrenByIndex.size();
        }

        public Node getChild(int index) {
            return this.childrenByIndex.get(index);
        }

        public int getChildIndex(Object child) {
            return this.childrenByIndex.indexOf(child);
        }

        public boolean isLeaf() {
            return this.childrenByIndex.isEmpty();
        }

        public Node findChild(Object key) {
            for (Node child : this.childrenByIndex) {
                if (!Objects.equal((Object)key, (Object)child.key.value)) continue;
                return child;
            }
            return null;
        }

        public String toString() {
            return this.key + " = " + this.value;
        }

        public boolean canFollow() {
            return CanFollow.fromSnippets(this.value.value.getSnippets()) != null;
        }

        @Nullable(value="if we have not made a request to the server for this path yet")
        public Path getFollowPath() {
            return this.followPath;
        }

        public void setFollowPath(@NotNull Path followPath) {
            this.followPath = followPath;
        }

        public boolean canBeRenderedAsLeaf() {
            if (!this.isLeaf() && this.getChildCount() <= 4) {
                for (int c = 0; c < this.getChildCount(); ++c) {
                    Node child = this.getChild(c);
                    if (child.isLeaf()) continue;
                    return false;
                }
                return true;
            }
            return this.isLeaf();
        }
    }

    public static class TypedValue {
        public final Type type;
        public final SnippetObject value;

        public TypedValue(Type type, SnippetObject value) {
            this.type = type;
            this.value = value;
        }

        public int hashCode() {
            return (this.type == null ? 0 : this.type.hashCode()) ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TypedValue)) {
                return false;
            }
            TypedValue other = (TypedValue)obj;
            return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.value, (Object)other.value);
        }

        public String toString() {
            return "TypedValue{type=" + this.type + ", value=" + this.value + '}';
        }
    }

    private static class PathBreadcrumbsItem
    extends BreadcrumbsItem {
        @NotNull
        private final TreePath myPath;

        public PathBreadcrumbsItem(@NotNull TreePath path) {
            this.myPath = path;
        }

        @NotNull
        public TreePath getTreePath() {
            return this.myPath;
        }

        @NotNull
        public String getDisplayText() {
            return StateController.getPathSegmentFor(null, (Node)this.myPath.getLastPathComponent()).getSegmentString();
        }
    }
}

