/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageCellController;
import com.android.tools.idea.editors.gfxtrace.models.AtomStream;
import com.android.tools.idea.editors.gfxtrace.service.Context;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceProtos;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.ContextPath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.widgets.CellList;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrubberController
extends ImageCellController<Data>
implements AtomStream.Listener {
    private static final Dimension PREVIEW_SIZE = JBUI.size((int)192, (int)192);
    @NotNull
    private static final Logger LOG = Logger.getInstance(ScrubberController.class);
    @NotNull
    private final PathStore<DevicePath> myRenderDevice = new PathStore();
    @NotNull
    private final RenderSettings myRenderSettings = new RenderSettings();
    @NotNull
    private Context mySelectedContext = Context.ALL;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new ScrubberController((GfxTraceEditor)editor).myList;
    }

    private ScrubberController(@NotNull GfxTraceEditor editor) {
        super(editor);
        this.myEditor.getAtomStream().addListener(this);
        this.usingListWidget(CellList.Orientation.HORIZONTAL, "Loading capture...", PREVIEW_SIZE);
        this.myRenderSettings.setMaxWidth(ScrubberController.PREVIEW_SIZE.width);
        this.myRenderSettings.setMaxHeight(ScrubberController.PREVIEW_SIZE.height);
        this.myRenderSettings.setWireframeMode(ServiceProtos.WireframeMode.None);
    }

    @Override
    public void loadCell(final Data cell, final Runnable onLoad) {
        DevicePath devicePath = this.myRenderDevice.getPath();
        if (devicePath == null) {
            return;
        }
        final ServiceClient client = this.myEditor.getClient();
        Rpc.listen(client.getFramebufferColor(devicePath, cell.atomPath, this.myRenderSettings), (Logger)LOG, (Rpc.Callback)new Rpc.Callback<ImageInfoPath>(){

            public void onFinish(Rpc.Result<ImageInfoPath> result) throws RpcException, ExecutionException {
                ImageInfoPath imagePath = (ImageInfoPath)result.get();
                ScrubberController.this.loadCellImage(cell, client, imagePath, onLoad);
            }
        });
    }

    @Override
    public void selected(@NotNull Data cell) {
        GfxTraceUtil.trackEvent("gfxTraceCommandSelected", "Scrubber", null);
        this.myEditor.getAtomStream().selectAtoms(cell.range, this);
    }

    @Nullable
    public List<Data> prepareData(@NotNull AtomsPath path, @NotNull AtomList atoms, @NotNull Context context) {
        ArrayList<Data> generatedList = new ArrayList<Data>();
        int frameCount = 0;
        long frameStart = -1L;
        for (Range contextRange : context.getRanges(atoms)) {
            for (long index = contextRange.getStart(); index < contextRange.getEnd(); ++index) {
                if (frameStart < 0L) {
                    frameStart = index;
                }
                if (!atoms.get(index).isEndOfFrame()) continue;
                Range frameRange = new Range().setStart(frameStart).setEnd(index + 1L);
                Data frameData = new Data(path.index(index), frameRange, Integer.toString(frameCount++));
                generatedList.add(frameData);
                frameStart = -1L;
            }
        }
        return generatedList;
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        AtomStream atoms = this.myEditor.getAtomStream();
        boolean doUpdate = false;
        ContextPath contextPath = event.findContextPath();
        if (contextPath != null && atoms.isLoaded()) {
            Context context = atoms.getContexts().find(contextPath.getID(), Context.ALL);
            doUpdate = !Objects.equals(context, this.mySelectedContext);
            this.mySelectedContext = context;
        }
        if (this.myRenderDevice.updateIfNotNull(event.findDevicePath())) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.update(atoms, false);
        }
    }

    @Override
    public void onAtomLoadingStart(AtomStream atoms) {
    }

    @Override
    public void onAtomLoadingComplete(AtomStream atoms) {
        this.update(atoms, true);
    }

    @Override
    public void onAtomsSelected(AtomRangePath path) {
        int index = 0;
        for (Data data : this.myList.items()) {
            if (data.range.contains(path.getLast())) {
                this.myList.selectItem(index, false);
                break;
            }
            ++index;
        }
    }

    private void update(AtomStream atoms, boolean expectAtomsAreLoaded) {
        if (atoms.isLoaded()) {
            List<Data> cells = this.prepareData(atoms.getPath(), atoms.getAtoms(), this.mySelectedContext);
            this.myList.setData(cells);
        } else if (expectAtomsAreLoaded) {
            ((ImageCellList)this.myList).setEmptyText("Failed to load capture");
        }
    }

    public static class Data
    extends ImageCellList.Data {
        @NotNull
        public final AtomPath atomPath;
        @NotNull
        public final Range range;

        public Data(AtomPath atomPath, @NotNull Range range, @NotNull String label) {
            super(label);
            this.atomPath = atomPath;
            this.range = range;
        }
    }
}

